/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.impl.AbstractExtender;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentCommands;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.config.ScrConfigurationImpl;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.apache.felix.scr.impl.runtime.ServiceComponentRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

public class Activator
extends AbstractExtender {
    private final ScrConfigurationImpl m_configuration = new ScrConfigurationImpl(this);
    private BundleContext m_context;
    private BundleContext m_globalContext;
    private Bundle m_bundle;
    private volatile ScrLogger logger;
    private Map<Long, BundleComponentActivator> m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;
    private ServiceRegistration<ServiceComponentRuntime> m_runtime_reg;
    private ComponentCommands m_componentCommands;

    @Override
    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.logger = new ScrLogger((ScrConfiguration)this.m_configuration, this.m_context);
        ClassUtils.setBundleContext(context);
        this.m_configuration.start(this.m_context);
    }

    public void restart(boolean globalExtender) {
        BundleContext context = this.m_globalContext;
        this.m_globalContext = globalExtender ? this.m_context.getBundle("System Bundle").getBundleContext() : this.m_context;
        if (ClassUtils.m_packageAdmin != null) {
            block5: {
                this.logger.log(3, "Stopping to restart with new globalExtender setting: {0}", null, globalExtender);
                try {
                    super.stop(context);
                }
                catch (Exception e) {
                    if (this.logger == null) break block5;
                    this.logger.log(1, "Exception stopping during restart", e);
                }
            }
            this.logger = new ScrLogger((ScrConfiguration)this.m_configuration, this.m_context);
        }
        try {
            this.logger.log(3, "Starting with globalExtender setting: {0}", null, globalExtender);
            super.start(this.m_globalContext);
        }
        catch (Exception e) {
            this.logger.log(1, "Exception starting during restart", e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.m_componentBundles = new HashMap<Long, BundleComponentActivator>();
        this.m_componentRegistry = new ComponentRegistry(this.m_configuration, this.logger);
        ServiceComponentRuntimeImpl runtime = new ServiceComponentRuntimeImpl(this.m_globalContext, this.m_componentRegistry);
        this.m_runtime_reg = this.m_context.registerService(ServiceComponentRuntime.class, (Object)runtime, this.m_componentRegistry.getServiceRegistrationProperties());
        this.m_componentRegistry.setRegistration(this.m_runtime_reg);
        this.logger.log(3, " Version = {0}", null, this.m_bundle.getVersion().toString());
        this.m_componentActor = new ComponentActorThread(this.logger);
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        super.doStart();
        this.m_componentCommands = new ComponentCommands(this.m_context, runtime, this.m_configuration);
        this.m_componentCommands.register();
        this.m_componentCommands.updateProvideScrInfoService(this.m_configuration.infoAsService());
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.m_configuration.stop();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this.m_componentCommands != null) {
            this.m_componentCommands.unregister();
        }
        if (this.m_runtime_reg != null) {
            this.m_runtime_reg.unregister();
            this.m_runtime_reg = null;
        }
        if (this.m_componentRegistry != null) {
            this.m_componentRegistry = null;
        }
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
        ClassUtils.close();
    }

    @Override
    protected ScrExtension doCreateExtension(Bundle bundle) throws Exception {
        return new ScrExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(Bundle bundle) {
        boolean loaded;
        if (bundle.getHeaders("").get("Service-Component") == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            this.logger.log(4, "Cannot get BundleContext of {0}.", null, bundle);
            return;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List extenderWires = wiring.getRequiredWires("osgi.extender");
        for (BundleWire wire : extenderWires) {
            if (!"osgi.component".equals(wire.getCapability().getAttributes().get("osgi.extender"))) continue;
            if (((BundleRevision)this.m_bundle.adapt(BundleRevision.class)).equals(wire.getProvider())) break;
            this.logger.log(4, "{0} wired to a different extender: {1}.", null, bundle, wire.getProvider().getBundle());
            return;
        }
        Long bundleId = bundle.getBundleId();
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            if (this.m_componentBundles.containsKey(bundleId)) {
                loaded = true;
            } else {
                this.m_componentBundles.put(bundleId, null);
                loaded = false;
            }
        }
        if (loaded) {
            this.logger.log(4, "Components for {0} already loaded. Nothing to do.", null, bundle);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.logger, this.m_componentRegistry, this.m_componentActor, context, this.m_configuration);
            ga.initialEnable();
            Map<Long, BundleComponentActivator> map2 = this.m_componentBundles;
            synchronized (map2) {
                this.m_componentBundles.put(bundleId, ga);
            }
        }
        catch (Exception e) {
            Map<Long, BundleComponentActivator> map3 = this.m_componentBundles;
            synchronized (map3) {
                this.m_componentBundles.remove(bundleId);
            }
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                this.logger.log(4, "{0} has been stopped while trying to activate its components. Trying again when the bundles gets started again.", e, bundle);
            }
            this.logger.log(1, "Error while loading components of {0}", e, bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeComponents(Bundle bundle) {
        BundleComponentActivator ga;
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            ga = this.m_componentBundles.remove(bundle.getBundleId());
        }
        if (ga != null) {
            try {
                int reason = this.isStopping() ? 5 : 6;
                ga.dispose(reason);
            }
            catch (Exception e) {
                this.logger.log(1, "Error while disposing components of {0}", e, bundle);
            }
        }
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        if (this.logger.isLogEnabled(4)) {
            if (bundle != null) {
                this.logger.log(4, "{0} : " + msg, null, bundle);
            } else {
                this.logger.log(4, msg, null);
            }
        }
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        if (this.logger.isLogEnabled(2)) {
            if (bundle != null) {
                this.logger.log(2, "{0} : " + msg, t, bundle);
            } else {
                this.logger.log(2, msg, t);
            }
        }
    }

    protected class ScrExtension {
        private final Bundle bundle;
        private final Lock stateLock = new ReentrantLock();

        public ScrExtension(Bundle bundle) {
            this.bundle = bundle;
        }

        public void start() {
            boolean acquired = false;
            try {
                try {
                    acquired = this.stateLock.tryLock(Activator.this.m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.this.logger.log(2, "The wait for {0} being destroyed before destruction has been interrupted.", e, this.bundle);
                }
                Activator.this.loadComponents(this.bundle);
            }
            finally {
                if (acquired) {
                    this.stateLock.unlock();
                }
            }
        }

        public void destroy() {
            boolean acquired = false;
            try {
                try {
                    acquired = this.stateLock.tryLock(Activator.this.m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Activator.this.logger.log(2, "The wait for {0} being started before destruction has been interrupted.", e, this.bundle);
                }
                Activator.this.disposeComponents(this.bundle);
            }
            finally {
                if (acquired) {
                    this.stateLock.unlock();
                }
            }
        }
    }
}

