/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.c4j;

import net.sourceforge.c4j.Instrumentor;
import net.sourceforge.c4j.Logger;

public class TraceLogger
implements Logger {
    public void classInvariantCheck(String className) {
        Instrumentor.trace("[" + Thread.currentThread().getName() + "] invariant check on : " + className);
    }

    public void preConditionCheck(String className, String method, Object[] parameters) {
        Instrumentor.trace("[" + Thread.currentThread().getName() + "] pre condition check on : " + this.getMethodDesc(className, method, parameters));
    }

    public void postConditionCheck(String className, String method, Object[] parameters) {
        Instrumentor.trace("[" + Thread.currentThread().getName() + "] post condition check on : " + this.getMethodDesc(className, method, parameters));
    }

    public void recursivePreConditionNotChecked(String className, String method, Object[] parameters) {
        Instrumentor.trace("[" + Thread.currentThread().getName() + "] pre condition not checked due to recursion in contract for: " + this.getMethodDesc(className, method, parameters));
    }

    public void recursivePostConditionNotChecked(String className, String method, Object[] parameters) {
        Instrumentor.trace("[" + Thread.currentThread().getName() + "] post condition not checked due to recursion in contract for: " + this.getMethodDesc(className, method, parameters));
    }

    public void recursiveInvariantNotChecked(String className) {
        Instrumentor.trace("[" + Thread.currentThread().getName() + "] invariant not checked due to recursion in contract for: " + className);
    }

    String getMethodDesc(String className, String method, Object[] parametersDef) {
        String parametersDesc = "";
        for (int i = 0; i < parametersDef.length - 1; ++i) {
            parametersDesc = parametersDesc + parametersDef[i].getClass().getSimpleName() + ", ";
        }
        if (parametersDef.length > 0) {
            Object param = parametersDef[parametersDef.length - 1];
            parametersDesc = parametersDesc + (param == null ? "" : param.getClass().getSimpleName());
        }
        String methodDesc = className + "." + method + "(" + parametersDesc + ")";
        return methodDesc;
    }
}

