/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.c4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;
import net.sourceforge.c4j.ContractReference;
import net.sourceforge.c4j.Instrumentor;
import net.sourceforge.c4j.Pure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentorUtil {
    public static String verifyContractReference(ContractReference contractReference, String className, ClassPool pool) {
        if (contractReference.contractClassName().equals("")) {
            Instrumentor.warn("Please set 'contractClassName' when defining a ContractReference annotation (offending class is '" + className + "').");
            return null;
        }
        String contractClassName = contractReference.contractClassName();
        String contractClassName2 = className.substring(0, className.lastIndexOf(46) + 1) + contractClassName;
        try {
            pool.get(contractClassName);
            return contractClassName;
        }
        catch (NotFoundException e1) {
            try {
                pool.get(contractClassName2);
                return contractClassName2;
            }
            catch (NotFoundException e2) {
                Instrumentor.warn("Contract '" + contractClassName + "' not found in class path (offending class is '" + className + "').");
                return null;
            }
        }
    }

    public static boolean instrumentedWith(CtBehavior method, final String methodName, final String signature) throws CannotCompileException {
        class Tmp {
            boolean b = false;

            Tmp() {
            }
        }
        final Tmp tmp = new Tmp();
        method.instrument(new ExprEditor(){
            {
            }

            public void edit(MethodCall m) {
                if (m.getMethodName().equals(methodName) && m.getSignature().equals(signature)) {
                    tmp.b = true;
                }
            }
        });
        return tmp.b;
    }

    public static String getSetReturnValueMethodName(CtBehavior behavior) throws NotFoundException {
        CtMethod[] methods;
        for (CtMethod method : methods = behavior.getDeclaringClass().getMethods()) {
            if (!method.getName().equals("___setReturnValuepost_" + behavior.getName() + InstrumentorUtil.getParameterTypeStringShort(behavior)) || !method.getSignature().equals("(Ljava/lang/Object;)V")) continue;
            return method.getName();
        }
        return null;
    }

    public static boolean methodAnnotatedWithPure(CtMethod method) {
        try {
            for (Object annotation : method.getAnnotations()) {
                if (!(annotation instanceof Pure)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isPure(CtMethod method) throws CannotCompileException {
        if (InstrumentorUtil.methodAnnotatedWithPure(method)) {
            return true;
        }
        try {
            List<CtClass> classHierarchy = InstrumentorUtil.getParents(method.getDeclaringClass());
            classHierarchy.add(0, method.getDeclaringClass());
            for (CtClass c : classHierarchy) {
                ArrayList interfaces = new ArrayList();
                Collections.addAll(interfaces, c.getInterfaces());
                for (int i = 0; i < interfaces.size(); ++i) {
                    CtClass interfaze = (CtClass)interfaces.get(i);
                    CtMethod m = null;
                    try {
                        m = interfaze.getMethod(method.getName(), method.getSignature());
                    }
                    catch (NotFoundException e) {
                        // empty catch block
                    }
                    if (m != null && InstrumentorUtil.methodAnnotatedWithPure(m)) {
                        return true;
                    }
                    Collections.addAll(interfaces, interfaze.getInterfaces());
                }
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        class Tmp {
            boolean fieldAccess = true;
            boolean other = true;

            Tmp() {
            }
        }
        final Tmp tmp = new Tmp();
        method.instrument(new ExprEditor(){
            {
            }

            public void edit(Cast c) {
            }

            public void edit(ConstructorCall c) {
                tmp.other = false;
            }

            public void edit(FieldAccess f) {
                tmp.fieldAccess = f.isReader() && tmp.fieldAccess;
            }

            public void edit(Handler h) {
                tmp.other = false;
            }

            public void edit(Instanceof i) {
            }

            public void edit(MethodCall m) {
                tmp.other = false;
            }

            public void edit(NewArray a) {
                tmp.other = false;
            }

            public void edit(NewExpr e) {
                tmp.other = false;
            }
        });
        return tmp.fieldAccess && tmp.other;
    }

    public static boolean isMainMethod(CtMethod targetMethod, ClassPool pool) throws NotFoundException {
        return targetMethod.getName().equals("main") && (targetMethod.getMethodInfo().getAccessFlags() & 8) == 8 && (targetMethod.getMethodInfo().getAccessFlags() & 1) == 1 && targetMethod.getParameterTypes().length == 1 && targetMethod.getParameterTypes()[0].equals(pool.get("java.lang.String[]")) && targetMethod.getReturnType().equals(pool.get("void"));
    }

    public static boolean preConditionExistsFor(CtMethod postCondition, List<CtMethod> preConditions) {
        String preName = "pre_" + postCondition.getName().substring(5, postCondition.getName().length());
        for (CtMethod method : preConditions) {
            if (!method.getName().equals(preName) || !method.getSignature().equals(postCondition.getSignature())) continue;
            return true;
        }
        return false;
    }

    public static boolean methodExistsForPreCondition(CtMethod preCondition, CtClass targetClass) {
        String name = preCondition.getName().substring(4, preCondition.getName().length());
        return InstrumentorUtil.methodExists(name, preCondition.getSignature(), targetClass);
    }

    public static boolean methodExistsForPostCondition(CtMethod postCondition, CtClass targetClass) {
        String name = postCondition.getName().substring(5, postCondition.getName().length());
        return InstrumentorUtil.methodExists(name, postCondition.getSignature(), targetClass);
    }

    public static boolean methodExists(String methodName, String signature, CtClass targetClass) {
        for (CtMethod ctMethod : targetClass.getMethods()) {
            if (!ctMethod.getName().equals(methodName) || !InstrumentorUtil.makeVoid(ctMethod.getSignature()).equals(signature)) continue;
            return true;
        }
        for (CtMethod ctMethod : targetClass.getDeclaredMethods()) {
            if (!ctMethod.getName().equals(methodName) || !InstrumentorUtil.makeVoid(ctMethod.getSignature()).equals(signature)) continue;
            return true;
        }
        for (CtMethod ctMethod : targetClass.getConstructors()) {
            if (!ctMethod.getName().equals(methodName) || !ctMethod.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static boolean methodExistsInClass(CtClass clazz, CtMethod method) {
        boolean methodExists = false;
        try {
            methodExists = clazz.getMethod(method.getName(), method.getSignature()) != null;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return methodExists;
    }

    public static boolean methodExistsInClass(CtClass clazz, String methodName, String signature) {
        CtMethod[] methods;
        for (CtMethod method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !method.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static String makeVoid(String signature) {
        return signature.substring(0, signature.indexOf(41) + 1) + "V";
    }

    public static List<CtClass> getParents(CtClass targetClass) throws NotFoundException {
        LinkedList<CtClass> parents = new LinkedList<CtClass>();
        CtClass parent = targetClass.getSuperclass();
        while (!parent.getName().equals("java.lang.Object")) {
            parents.add(parent);
            parent = parent.getSuperclass();
        }
        return parents;
    }

    public static Set<CtClass> getContracts(CtClass targetClass, ClassPool pool) throws ClassNotFoundException, NotFoundException {
        HashSet<CtClass> contracts = new HashSet<CtClass>();
        ArrayList interfaces = new ArrayList();
        Collections.addAll(interfaces, targetClass.getInterfaces());
        for (int i = 0; i < interfaces.size(); ++i) {
            CtClass interfaze = (CtClass)interfaces.get(i);
            CtClass interfaceContract = InstrumentorUtil.getContract(interfaze, pool);
            if (interfaceContract != null && !InstrumentorUtil.superClassInstrumentedWith(targetClass, interfaceContract)) {
                contracts.add(interfaceContract);
            }
            Collections.addAll(interfaces, interfaze.getInterfaces());
        }
        CtClass classContract = InstrumentorUtil.getContract(targetClass, pool);
        if (classContract != null) {
            contracts.add(classContract);
        }
        return contracts;
    }

    public static CtClass getContract(CtClass ctClass, ClassPool pool) throws NotFoundException, ClassNotFoundException {
        ContractReference contractReference;
        String contractClassName;
        Annotation annotation;
        ClassFile cf = ctClass.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        if (annotationsAttribute != null && (annotation = annotationsAttribute.getAnnotation("net.sourceforge.c4j.ContractReference")) != null && (contractClassName = InstrumentorUtil.verifyContractReference(contractReference = (ContractReference)annotation.toAnnotationType(ContractReference.class.getClassLoader(), pool), ctClass.getName(), pool)) != null) {
            Instrumentor.debug("Found contract '" + contractClassName + "'");
            if (Instrumentor.exclude(contractClassName)) {
                Instrumentor.debug("Excluding '" + contractClassName + "'");
                return null;
            }
            return pool.get(contractClassName);
        }
        return null;
    }

    public static boolean superClassInstrumentedWith(CtClass targetClass, CtClass interfaceContract) throws NotFoundException {
        List<CtClass> parents = InstrumentorUtil.getParents(targetClass);
        for (CtClass parent : parents) {
            CtField[] fields;
            for (CtField field : fields = parent.getDeclaredFields()) {
                if (!field.getType().equals(interfaceContract)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean methodDeclaredInClass(CtClass clazz, CtMethod method) {
        boolean methodExists = false;
        try {
            methodExists = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()) != null;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return methodExists;
    }

    public static boolean methodDeclaredInClass(CtClass clazz, String methodName, String signature) {
        CtMethod[] methods;
        for (CtMethod method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !method.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static boolean postConditionExistsFor(CtMethod preCondition, List<CtMethod> postConditions) {
        String postName = "post_" + preCondition.getName().substring(4, preCondition.getName().length());
        for (CtMethod method : postConditions) {
            if (!method.getName().equals(postName) || !method.getSignature().equals(preCondition.getSignature())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPreconditionForConstructor(CtClass targetClass, CtMethod preCondition) {
        String methodName = preCondition.getName().substring("pre_".length());
        for (CtConstructor constructor : targetClass.getConstructors()) {
            if (!constructor.getName().equals(methodName) || !InstrumentorUtil.makeVoid(constructor.getSignature()).equals(preCondition.getSignature())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPostconditionForConstructor(CtClass targetClass, CtMethod postCondition) {
        String methodName = postCondition.getName().substring("post_".length());
        for (CtConstructor constructor : targetClass.getConstructors()) {
            if (!constructor.getName().equals(methodName) || !InstrumentorUtil.makeVoid(constructor.getSignature()).equals(postCondition.getSignature())) continue;
            return true;
        }
        return false;
    }

    public static boolean oneArgConstructorExists(CtClass contractClass) {
        for (CtConstructor constructor : contractClass.getConstructors()) {
            try {
                if (constructor.getParameterTypes().length != 1) continue;
                return true;
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }

    public static List<CtField> getMatchingMembers(CtClass targetClass, CtClass contractClass, ClassPool pool, String prefix, boolean mustBeCloneable) throws NotFoundException {
        CtField[] contractMembers;
        LinkedList<CtField> oldMembers = new LinkedList<CtField>();
        block0: for (CtField contractMember : contractMembers = contractClass.getDeclaredFields()) {
            if (!contractMember.getName().startsWith(prefix)) continue;
            if (Modifier.isPublic((int)contractMember.getModifiers())) {
                CtField[] targetMembers;
                for (CtField targetMember : targetMembers = targetClass.getDeclaredFields()) {
                    if (!contractMember.getName().equals(prefix + targetMember.getName()) || !contractMember.getType().getName().equals(targetMember.getType().getName())) continue;
                    if (!mustBeCloneable || contractMember.getType().isPrimitive() || contractMember.getType().subtypeOf(pool.get("java.lang.Cloneable"))) {
                        oldMembers.add(contractMember);
                        continue block0;
                    }
                    Instrumentor.warn("Contract defines an \"" + prefix + "\" member that is not java.lang.Cloneable (offending member is '" + contractMember.getType().getName() + " " + contractClass.getName() + "." + contractMember.getName() + "').");
                }
                continue;
            }
            Instrumentor.warn("Contract defines an \"" + prefix + "\" member that is not public (offending member is '" + contractMember.getType().getName() + " " + contractClass.getName() + "." + contractMember.getName() + "').");
        }
        return oldMembers;
    }

    public static CtMethod getSetOldValuesMethod(CtClass targetClass) throws CannotCompileException {
        try {
            return targetClass.getMethod("___setOldValues", "()V");
        }
        catch (NotFoundException e) {
            CtMethod m = CtNewMethod.make((String)"private void ___setOldValues() {}", (CtClass)targetClass);
            targetClass.addMethod(m);
            return m;
        }
    }

    public static CtMethod getSetCurrentValuesMethod(CtClass targetClass) throws CannotCompileException {
        try {
            return targetClass.getMethod("___setCurrentValues", "()V");
        }
        catch (NotFoundException e) {
            CtMethod m = CtNewMethod.make((String)"private void ___setCurrentValues() {}", (CtClass)targetClass);
            targetClass.addMethod(m);
            return m;
        }
    }

    public static boolean callsSuper(CtClass targetClass, String methodName, CtClass[] parameterTypes) throws NotFoundException, CannotCompileException {
        for (CtMethod method : targetClass.getMethods()) {
            if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            return InstrumentorUtil.callsSuper(method);
        }
        return false;
    }

    public static boolean callsSuper(final CtMethod method) throws CannotCompileException {
        class Tmp {
            boolean callsSuper = false;

            Tmp() {
            }
        }
        final Tmp tmp = new Tmp();
        method.instrument(new ExprEditor(){
            {
            }

            public void edit(Cast c) {
            }

            public void edit(ConstructorCall c) {
            }

            public void edit(FieldAccess f) {
            }

            public void edit(Handler h) {
            }

            public void edit(Instanceof i) {
            }

            public void edit(MethodCall methodCall) {
                if (!tmp.callsSuper) {
                    boolean super1 = methodCall.isSuper();
                    boolean super2 = false;
                    try {
                        super2 = method.getDeclaringClass().subclassOf(methodCall.getMethod().getDeclaringClass());
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                    }
                    boolean equals = methodCall.getMethodName().equals(method.getName());
                    boolean equals2 = methodCall.getSignature().equals(method.getSignature());
                    tmp.callsSuper = super1 && equals && equals2;
                }
            }

            public void edit(NewArray a) {
            }

            public void edit(NewExpr e) {
            }
        });
        return tmp.callsSuper;
    }

    public static String getParameterTypeStringShort(CtBehavior behavior) throws NotFoundException {
        String s = "";
        CtClass[] parameterTypes = behavior.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            s = s + "_" + parameterTypes[i].getSimpleName().replace("[]", "A");
        }
        return s;
    }

    public static boolean fieldExistsInClass(CtClass targetClass, String fieldName) {
        try {
            targetClass.getDeclaredField(fieldName);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }
}

