/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.c4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import net.sourceforge.c4j.ContractBase;
import net.sourceforge.c4j.InstrumentorUtil;
import net.sourceforge.c4j.TraceLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumentor
implements ClassFileTransformer {
    private static final String INITIALIZED_FLAG_VAR = "___initialized";
    private static int s_contractIndex = 0;
    private static Map<String, Integer> s_contracts = new HashMap<String, Integer>();
    private static Map<String, String> m_options = new HashMap<String, String>();
    private Map<String, byte[]> m_instrumentedClasses;
    private String m_classFileDir;
    private static Pattern m_includes;
    private static Pattern m_excludes;

    public static void premain(String options, Instrumentation ins) {
        ins.addTransformer(new Instrumentor(options));
    }

    private static int getAndIncContractIndex() {
        return s_contractIndex++;
    }

    public Instrumentor(String options) {
        this.init(options);
    }

    private void init(String options) {
        this.m_instrumentedClasses = new HashMap<String, byte[]>();
        if (options != null) {
            String excludes;
            String includes;
            StringTokenizer tokenizer = new StringTokenizer(options, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int equalsIndex = token.indexOf(61);
                if (equalsIndex == -1 || equalsIndex == 0) {
                    Instrumentor.info("Invalid option: '" + token + "'.");
                    continue;
                }
                m_options.put(token.substring(0, equalsIndex).toLowerCase(), token.substring(equalsIndex + 1));
            }
            Instrumentor.debug("Found options: " + options);
            this.m_classFileDir = m_options.get("classfiledir");
            if (this.m_classFileDir != null) {
                File classfileDir = new File(this.m_classFileDir);
                if (!classfileDir.exists()) {
                    classfileDir.mkdirs();
                }
                Instrumentor.debug("Using dir for instrumented class files: " + classfileDir);
            }
            if ((includes = m_options.get("includes")) != null) {
                m_includes = Pattern.compile(includes);
            }
            if ((excludes = m_options.get("excludes")) != null) {
                m_excludes = Pattern.compile(excludes);
            }
            if ("true".equalsIgnoreCase(m_options.get("trace"))) {
                ContractBase.addLogger(new TraceLogger());
            }
        }
    }

    public byte[] transform(ClassLoader loader, String classNameWithSlashes, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        String className = classNameWithSlashes.replace('/', '.');
        if (className.startsWith("net.sourceforge.c4j") || className.startsWith("javassist") || className.startsWith("sunw.") || className.startsWith("sun.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.sun.")) {
            return classfileBuffer;
        }
        Instrumentor.debug("Finding contracts for '" + className + "'.");
        try {
            CtClass targetClass;
            byte[] byteCode;
            ClassPool pool = new ClassPool(true);
            if (loader == null) {
                pool.appendSystemPath();
            } else {
                pool.insertClassPath((ClassPath)new LoaderClassPath(loader));
            }
            if (classfileBuffer != null && classfileBuffer.length > 0) {
                pool.insertClassPath((ClassPath)new ByteArrayClassPath(className, classfileBuffer));
            }
            if ((byteCode = this.m_instrumentedClasses.get(className)) != null && byteCode.length > 0) {
                pool.insertClassPath((ClassPath)new ByteArrayClassPath(className, byteCode));
            }
            if ((targetClass = pool.get(className)).isInterface()) {
                return classfileBuffer;
            }
            List<CtClass> classHierarchy = InstrumentorUtil.getParents(targetClass);
            classHierarchy.add(0, targetClass);
            boolean contractExists = false;
            for (int i = classHierarchy.size() - 1; i >= 0; --i) {
                Set<CtClass> contracts = InstrumentorUtil.getContracts(classHierarchy.get(i), pool);
                boolean bl = contractExists = !contracts.isEmpty() || contractExists;
                if (!contractExists) continue;
                Instrumentor.debug("Found contract for '" + classHierarchy.get(i).getName() + "'");
                this.instrumentClass(classHierarchy.get(i), contracts, pool);
            }
            byte[] result = this.m_instrumentedClasses.get(targetClass.getName());
            if (result != null && this.m_classFileDir != null) {
                try {
                    File f = new File(this.m_classFileDir, className + ".class");
                    f.createNewFile();
                    FileOutputStream o = new FileOutputStream(f);
                    ((OutputStream)o).write(result);
                    o.flush();
                    ((OutputStream)o).close();
                    Instrumentor.info("Wrote '" + className + ".class' to file '" + f + "'.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
        catch (NotFoundException e) {
            Instrumentor.warn("Not able to load class: '" + className + "'.");
            Instrumentor.debug("ClassLoader: '" + loader + "'.");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classfileBuffer;
    }

    protected static boolean exclude(String className) {
        if (m_includes != null && m_includes.matcher(className).matches()) {
            return false;
        }
        return m_excludes != null && m_excludes.matcher(className).matches();
    }

    private byte[] instrumentClass(CtClass targetClass, Set<CtClass> contracts, ClassPool pool) throws NotFoundException, CannotCompileException, IOException {
        byte[] byteCode = this.m_instrumentedClasses.get(targetClass.getName());
        if (byteCode != null) {
            if (byteCode.length == targetClass.toBytecode().length) {
                Instrumentor.debug("'" + targetClass.getName() + "' already instrumented.");
                return byteCode;
            }
            targetClass.defrost();
        }
        for (CtClass contract : contracts) {
            Integer contractIndex = s_contracts.get(contract.getName());
            if (contractIndex == null) {
                contractIndex = Instrumentor.getAndIncContractIndex();
                s_contracts.put(contract.getName(), contractIndex);
            }
            boolean extendsContractBase = contract.subclassOf(pool.get("net.sourceforge.c4j.ContractBase"));
            this.addContractToClass(targetClass, contract, extendsContractBase, contractIndex, pool);
            Instrumentor.info("'" + targetClass.getName() + "' and descendants will be guarded by '" + contract.getName() + "'");
        }
        if (!InstrumentorUtil.fieldExistsInClass(targetClass, INITIALIZED_FLAG_VAR)) {
            CtField initializedFlag = CtField.make((String)"private boolean ___initialized = false;", (CtClass)targetClass);
            targetClass.addField(initializedFlag);
        }
        this.instrumentConstructors(targetClass);
        this.instrumentMethods(targetClass.getDeclaredMethods(), pool);
        if (targetClass.isModified()) {
            byteCode = targetClass.toBytecode();
            this.m_instrumentedClasses.put(targetClass.getName(), byteCode);
        }
        Instrumentor.debug("Instrumented '" + targetClass.getName() + "'.");
        return byteCode;
    }

    private void addContractToClass(CtClass targetClass, CtClass contractClass, boolean extendsContractBase, int contractIndex, ClassPool pool) throws CannotCompileException, NotFoundException {
        CtMethod[] contractMethods = contractClass.getMethods();
        CtMethod classInvariant = null;
        LinkedList<CtMethod> preConditions = new LinkedList<CtMethod>();
        LinkedList<CtMethod> postConditions = new LinkedList<CtMethod>();
        for (CtMethod contractMethod : contractMethods) {
            String methodName = contractMethod.getName();
            if (methodName.equals("classInvariant")) {
                classInvariant = contractMethod;
            }
            if (methodName.startsWith("pre_")) {
                preConditions.add(contractMethod);
            }
            if (!methodName.startsWith("post_")) continue;
            postConditions.add(contractMethod);
        }
        if (classInvariant != null || preConditions.size() > 0 || postConditions.size() > 0) {
            this.addMemberField(targetClass, contractClass, contractIndex);
            this.addClassInvariantMethod(targetClass, classInvariant, contractIndex, extendsContractBase);
            this.addPreConditionMethods(targetClass, preConditions, postConditions, extendsContractBase, contractIndex);
            this.addPostConditionMethods(targetClass, postConditions, preConditions, extendsContractBase, contractIndex);
        }
    }

    private void instrumentMethods(CtMethod[] targetMethods, ClassPool pool) throws CannotCompileException, NotFoundException {
        for (CtMethod targetMethod : targetMethods) {
            if (targetMethod.getName().equals("classInvariant") || targetMethod.getName().startsWith("___setReturnValue") || targetMethod.getName().startsWith("pre_") || targetMethod.getName().startsWith("post_") || targetMethod.getName().startsWith("___setOldValues")) continue;
            boolean isPure = InstrumentorUtil.isPure(targetMethod);
            this.addPreConditionCall(targetMethod);
            this.addPostConditionCall(targetMethod);
            if (isPure) continue;
            this.addClassInvariantCall(targetMethod, pool);
        }
    }

    private void addPreConditionMethods(CtClass targetClass, List<CtMethod> preConditions, List<CtMethod> postConditions, boolean extendsContractBase, int contractIndex) throws NotFoundException, CannotCompileException {
        for (CtMethod preCondition : preConditions) {
            if (!InstrumentorUtil.methodExistsForPreCondition(preCondition, targetClass)) {
                Instrumentor.error("'" + targetClass.getName() + "' does not define a method for pre condition '" + preCondition.getName() + preCondition.getSignature() + "' defined in '" + preCondition.getDeclaringClass().getName() + "'.");
                if (!"false".equalsIgnoreCase(m_options.get("exit-on-unknown-contract"))) {
                    Instrumentor.error("The Java process is now exited. If you want to override this default behavior,");
                    Instrumentor.error("add a 'exit-on-unknown-contract=false' parameter to the C4J javaagent library");
                    System.exit(1);
                }
            }
            String staticOrInstanceRef = Modifier.isStatic((int)preCondition.getModifiers()) ? preCondition.getDeclaringClass().getName() : "___contract" + contractIndex;
            String commonMethodBody = staticOrInstanceRef + "." + preCondition.getName() + "($$);" + "net.sourceforge.c4j.ContractBase.preConditionCheck(\"" + targetClass.getName() + "\", \"" + preCondition.getName().substring(4) + "\", $args);";
            boolean callSuper = InstrumentorUtil.methodExistsInClass(targetClass.getSuperclass(), preCondition) && !InstrumentorUtil.isPreconditionForConstructor(targetClass, preCondition);
            CtMethod preConditionMethod = CtNewMethod.copy((CtMethod)preCondition, (CtClass)targetClass, null);
            if (InstrumentorUtil.methodDeclaredInClass(targetClass, preCondition)) {
                this.addPreconditionToExistingMethod(targetClass, contractIndex, preCondition, commonMethodBody, callSuper, preConditionMethod);
                continue;
            }
            if (Modifier.isStatic((int)preCondition.getModifiers())) {
                this.addStaticPreCondition(targetClass, commonMethodBody, preConditionMethod);
                continue;
            }
            this.addPreCondition(targetClass, contractIndex, preCondition, commonMethodBody, callSuper, preConditionMethod, extendsContractBase);
        }
    }

    private void addPreCondition(CtClass targetClass, int contractIndex, CtMethod preCondition, String commonMethodBody, boolean callSuper, CtMethod preConditionMethod, boolean extendsContractBase) throws CannotCompileException {
        String body = "";
        body = callSuper ? "super." + preCondition.getName() + "($$);" + this.getProtectedPreCondition(commonMethodBody, contractIndex, preCondition.getName()) : commonMethodBody;
        String signature = contractIndex + preCondition.getName().substring(4) + preCondition.getSignature();
        String checkRecursion = extendsContractBase ? "boolean ___entered = false;if (___contract" + contractIndex + ".runningContract(\"" + signature + "\"))" + "{net.sourceforge.c4j.ContractBase.recursivePreConditionNotChecked(\"" + targetClass.getName() + "\", \"" + preCondition.getName().substring(4) + "\", $args);" + " return;}" + "___contract" + contractIndex + ".enterContract(\"" + signature + "\");" + "___entered = true;" : "";
        body = "{ " + checkRecursion + " try {" + body + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); }" + (extendsContractBase ? " finally { if (___entered) ___contract" + contractIndex + ".exitContract(\"" + signature + "\");}" : "") + " }";
        preConditionMethod.setBody(body);
        targetClass.addMethod(preConditionMethod);
    }

    private void addStaticPreCondition(CtClass targetClass, String commonMethodBody, CtMethod preConditionMethod) throws CannotCompileException {
        String body = "{ try {" + commonMethodBody + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); } }";
        preConditionMethod.setBody(body);
        targetClass.addMethod(preConditionMethod);
    }

    private void addPreconditionToExistingMethod(CtClass targetClass, int contractIndex, CtMethod preCondition, String commonMethodBody, boolean callSuper, CtMethod preConditionMethod) throws CannotCompileException, NotFoundException {
        preConditionMethod.setName(preCondition.getName() + "__contract" + contractIndex);
        if (callSuper) {
            commonMethodBody = this.getProtectedPreCondition(commonMethodBody, contractIndex, preCondition.getName());
        }
        preConditionMethod.setBody("{ try {" + commonMethodBody + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); } }");
        targetClass.addMethod(preConditionMethod);
        CtMethod declaredPreCondition = targetClass.getDeclaredMethod(preCondition.getName(), preCondition.getParameterTypes());
        declaredPreCondition.insertAfter("{" + preConditionMethod.getName() + "($$);}");
    }

    private String getProtectedPreCondition(String preConditionCall, int contractIndex, String preConditionName) {
        return "try {" + preConditionCall + "} catch (java.lang.AssertionError e) {" + "net.sourceforge.c4j.Instrumentor.error(\"Pre conditions may not be strengthened (offending pre condition is '\"+___contract" + contractIndex + ".getClass().getName() + \"." + preConditionName + "())\");" + "}";
    }

    private void addPostConditionMethods(CtClass targetClass, List<CtMethod> postConditions, List<CtMethod> preConditions, boolean extendsContractBase, int contractIndex) throws NotFoundException, CannotCompileException {
        for (CtMethod postCondition : postConditions) {
            if (!InstrumentorUtil.methodExistsForPostCondition(postCondition, targetClass)) {
                Instrumentor.error("'" + targetClass.getName() + "' does not define a method for post condition '" + postCondition.getName() + postCondition.getSignature() + "' defined in '" + postCondition.getDeclaringClass().getName() + "'.");
                if (!"false".equalsIgnoreCase(m_options.get("exit-on-unknown-contract"))) {
                    Instrumentor.error("The Java process is now exited. If you want to override this default behavior,");
                    Instrumentor.error("add a 'exit-on-unknown-contract=false' parameter to the C4J javaagent library,");
                    Instrumentor.error("e.g. -javaagent:lib/c4j.jar=exit-on-unknown-contract=false -ea");
                    System.exit(1);
                }
            }
            String postConditionName = postCondition.getName();
            String commonMethodBody = "___contract" + contractIndex + "." + postConditionName + "($$);" + "net.sourceforge.c4j.ContractBase.postConditionCheck(\"" + targetClass.getName() + "\", \"" + postConditionName.substring(5) + "\", $args);";
            if (InstrumentorUtil.methodDeclaredInClass(targetClass, postCondition)) {
                this.addPostConditionToExistingMethod(targetClass, contractIndex, postCondition, commonMethodBody);
                continue;
            }
            int modifiers = postCondition.getModifiers();
            if (extendsContractBase) {
                this.addSetReturnValueMethod(targetClass, postCondition, modifiers);
            }
            if (Modifier.isStatic((int)modifiers)) {
                this.addStaticPostCondition(targetClass, postCondition);
                continue;
            }
            this.addPostCondition(targetClass, contractIndex, postCondition, commonMethodBody, extendsContractBase);
        }
    }

    private void addPostCondition(CtClass targetClass, int contractIndex, CtMethod postCondition, String commonMethodBody, boolean extendsContractBase) throws CannotCompileException, NotFoundException {
        String body = "";
        boolean callSuper = InstrumentorUtil.methodExistsInClass(targetClass.getSuperclass(), postCondition) && !InstrumentorUtil.isPostconditionForConstructor(targetClass, postCondition);
        body = callSuper ? this.getProtectedPostCondition(commonMethodBody, contractIndex, postCondition.getName()) : commonMethodBody;
        String signature = contractIndex + postCondition.getName().substring(5) + postCondition.getSignature();
        String checkRecursion = extendsContractBase ? "boolean ___entered = false;if (___contract" + contractIndex + ".runningContract(\"" + signature + "\"))" + "{net.sourceforge.c4j.ContractBase.recursivePostConditionNotChecked(\"" + targetClass.getName() + "\", \"" + postCondition.getName().substring(5) + "\", $args);" + " return;}" + "___contract" + contractIndex + ".enterContract(\"" + signature + "\");" + " ___entered = true;" : "";
        body = "{ " + checkRecursion + " try {" + body + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); } " + (extendsContractBase ? " finally { if (___entered) ___contract" + contractIndex + ".exitContract(\"" + signature + "\");}" : "") + " }";
        CtMethod postConditionMethod = CtNewMethod.copy((CtMethod)postCondition, (CtClass)targetClass, null);
        postConditionMethod.setBody(body);
        targetClass.addMethod(postConditionMethod);
    }

    private void addStaticPostCondition(CtClass targetClass, CtMethod postCondition) throws CannotCompileException {
        String body = postCondition.getDeclaringClass().getName() + "." + postCondition.getName() + "($$);";
        body = body + "net.sourceforge.c4j.ContractBase.postConditionCheck(\"" + targetClass.getName() + "\", \"" + postCondition.getName().substring(5) + "\", $args);";
        body = "{ try {" + body + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); } }";
        CtMethod postConditionMethod = CtNewMethod.copy((CtMethod)postCondition, (CtClass)targetClass, null);
        postConditionMethod.setBody(body);
        targetClass.addMethod(postConditionMethod);
    }

    private void addSetReturnValueMethod(CtClass targetClass, CtMethod postCondition, int modifiers) throws NotFoundException, CannotCompileException {
        String setReturnValueName = "___setReturnValue" + postCondition.getName() + InstrumentorUtil.getParameterTypeStringShort((CtBehavior)postCondition);
        String staticString = Modifier.isStatic((int)modifiers) ? " static" : "";
        CtMethod setReturnValueMethod = CtNewMethod.make((String)("public" + staticString + " void " + setReturnValueName + "(Object returnValue) {}"), (CtClass)targetClass);
        String s = "{";
        if (InstrumentorUtil.methodExistsInClass(targetClass.getSuperclass(), setReturnValueMethod) && !Modifier.isStatic((int)modifiers)) {
            s = s + "super." + setReturnValueName + "($$);";
        }
        s = s + "net.sourceforge.c4j.ContractBase.pushReturnValue();net.sourceforge.c4j.ContractBase.setReturnValue($$);}";
        setReturnValueMethod.setBody(s);
        targetClass.addMethod(setReturnValueMethod);
    }

    private void addPostConditionToExistingMethod(CtClass targetClass, int contractIndex, CtMethod postCondition, String commonMethodBody) throws CannotCompileException, NotFoundException {
        boolean callSuper;
        CtMethod postConditionMethod = CtNewMethod.copy((CtMethod)postCondition, (CtClass)targetClass, null);
        String postConditionName = postCondition.getName();
        postConditionMethod.setName(postConditionName + "__contract" + contractIndex);
        boolean bl = callSuper = InstrumentorUtil.methodExistsInClass(targetClass.getSuperclass(), postCondition) && !InstrumentorUtil.isPostconditionForConstructor(targetClass, postCondition);
        if (callSuper) {
            commonMethodBody = this.getProtectedPostCondition(commonMethodBody, contractIndex, postConditionName);
        }
        postConditionMethod.setBody("{ try {" + commonMethodBody + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); } }");
        targetClass.addMethod(postConditionMethod);
        CtMethod declaredPostCondition = targetClass.getDeclaredMethod(postConditionName, postCondition.getParameterTypes());
        declaredPostCondition.insertAfter("{" + postConditionMethod.getName() + "($$);}");
    }

    private String getProtectedPostCondition(String commonMethodBody, int contractIndex, String postConditionName) {
        String body = commonMethodBody + "try {" + "super." + postConditionName + "($$);" + "} catch (java.lang.AssertionError e) {" + "net.sourceforge.c4j.Instrumentor.error(\"Post conditions may not be weakened (offending post condition is '\"+___contract" + contractIndex + ".getClass().getName() + \"." + postConditionName + "())\");" + "throw e;" + "}";
        return body;
    }

    private void addClassInvariantMethod(CtClass targetClass, CtMethod classInvariant, int contractIndex, boolean extendsContractBase) throws NotFoundException, CannotCompileException {
        if (classInvariant == null) {
            return;
        }
        String commonMethodBody = "___contract" + contractIndex + ".classInvariant();" + "net.sourceforge.c4j.ContractBase.classInvariantCheck(\"" + targetClass.getName() + "\");";
        CtMethod classInvariantCall = CtNewMethod.copy((CtMethod)classInvariant, (CtClass)targetClass, null);
        if (InstrumentorUtil.methodDeclaredInClass(targetClass, classInvariant)) {
            classInvariantCall.setName(classInvariantCall.getName() + "__contract" + contractIndex);
            commonMethodBody = "{ try {" + commonMethodBody + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); } }";
            classInvariantCall.setBody(commonMethodBody);
            targetClass.addMethod(classInvariantCall);
            CtMethod declaredClassInvariant = targetClass.getDeclaredMethod(classInvariant.getName(), classInvariant.getParameterTypes());
            declaredClassInvariant.insertAfter("{" + classInvariantCall.getName() + "();}");
        } else {
            if (InstrumentorUtil.methodExistsInClass(targetClass.getSuperclass(), classInvariant)) {
                commonMethodBody = "super.classInvariant();" + commonMethodBody;
            }
            String signature = contractIndex + "invariant";
            String checkRecursion = extendsContractBase ? "boolean ___entered = false;if (___contract" + contractIndex + ".runningContract(\"" + signature + "\"))" + "{net.sourceforge.c4j.ContractBase.recursiveInvariantNotChecked(\"" + targetClass.getName() + "\");" + " return;}" + "___contract" + contractIndex + ".enterContract(\"" + signature + "\");" + " ___entered = true;" : "";
            commonMethodBody = "{ " + checkRecursion + " try {" + commonMethodBody + "} catch(Exception contractException) { throw new java.lang.AssertionError(contractException); }" + (extendsContractBase ? " finally { if (___entered) ___contract" + contractIndex + ".exitContract(\"" + signature + "\");}" : "") + " }";
            classInvariantCall.setBody(commonMethodBody);
            targetClass.addMethod(classInvariantCall);
        }
    }

    private boolean addClassInvariantCall(CtMethod targetMethod, ClassPool pool) throws CannotCompileException, NotFoundException {
        if (!InstrumentorUtil.methodExistsInClass(targetMethod.getDeclaringClass(), "classInvariant", "()V") || InstrumentorUtil.instrumentedWith((CtBehavior)targetMethod, "classInvariant", "()V") || targetMethod.getDeclaringClass().equals(pool.get("java.lang.Object")) || InstrumentorUtil.isMainMethod(targetMethod, pool) || Modifier.isAbstract((int)targetMethod.getModifiers()) || Modifier.isStatic((int)targetMethod.getModifiers())) {
            return false;
        }
        targetMethod.insertAfter("if (___initialized) {classInvariant();}");
        return true;
    }

    private boolean addPostConditionCall(CtMethod targetMethod) throws CannotCompileException, NotFoundException {
        if (!InstrumentorUtil.methodExistsInClass(targetMethod.getDeclaringClass(), "post_" + targetMethod.getName(), InstrumentorUtil.makeVoid(targetMethod.getSignature())) || InstrumentorUtil.instrumentedWith((CtBehavior)targetMethod, "post_" + targetMethod.getName(), InstrumentorUtil.makeVoid(targetMethod.getSignature())) || Modifier.isAbstract((int)targetMethod.getModifiers())) {
            return false;
        }
        String setReturnValueMethodName = InstrumentorUtil.getSetReturnValueMethodName((CtBehavior)targetMethod);
        if (setReturnValueMethodName != null) {
            if (targetMethod.getReturnType().isPrimitive()) {
                targetMethod.insertAfter(setReturnValueMethodName + "(($w)$_);");
            } else {
                targetMethod.insertAfter(setReturnValueMethodName + "($_);");
            }
        }
        targetMethod.insertAfter("post_" + targetMethod.getName() + "($$);");
        if (setReturnValueMethodName != null) {
            targetMethod.insertAfter("net.sourceforge.c4j.ContractBase.popReturnValue();");
        }
        if (InstrumentorUtil.methodExists("pre_" + targetMethod.getName(), InstrumentorUtil.makeVoid(targetMethod.getSignature()), targetMethod.getDeclaringClass())) {
            targetMethod.insertAfter("net.sourceforge.c4j.ContractBase.popPreconditionValuesMap();");
        }
        return true;
    }

    private boolean addPreConditionCall(CtMethod targetMethod) throws CannotCompileException {
        if (!InstrumentorUtil.methodExistsInClass(targetMethod.getDeclaringClass(), "pre_" + targetMethod.getName(), InstrumentorUtil.makeVoid(targetMethod.getSignature())) || InstrumentorUtil.instrumentedWith((CtBehavior)targetMethod, "pre_" + targetMethod.getName(), InstrumentorUtil.makeVoid(targetMethod.getSignature())) || Modifier.isAbstract((int)targetMethod.getModifiers())) {
            return false;
        }
        targetMethod.insertBefore("pre_" + targetMethod.getName() + "($$);");
        if (InstrumentorUtil.methodExists("post_" + targetMethod.getName(), InstrumentorUtil.makeVoid(targetMethod.getSignature()), targetMethod.getDeclaringClass())) {
            targetMethod.insertBefore("net.sourceforge.c4j.ContractBase.pushPreconditionValuesMap();");
        }
        return true;
    }

    private void instrumentConstructors(CtClass targetClass) throws CannotCompileException, NotFoundException {
        CtConstructor[] constructors;
        for (CtConstructor constructor : constructors = targetClass.getConstructors()) {
            CtField[] fields;
            if (InstrumentorUtil.methodExistsInClass(constructor.getDeclaringClass(), "pre_" + constructor.getName(), InstrumentorUtil.makeVoid(constructor.getSignature())) && !InstrumentorUtil.instrumentedWith((CtBehavior)constructor, "pre_" + constructor.getName(), InstrumentorUtil.makeVoid(constructor.getSignature()))) {
                constructor.insertBeforeBody("pre_" + constructor.getName() + "($$);");
            }
            if (InstrumentorUtil.methodExistsInClass(constructor.getDeclaringClass(), "post_" + constructor.getName(), InstrumentorUtil.makeVoid(constructor.getSignature())) && !InstrumentorUtil.instrumentedWith((CtBehavior)constructor, "post_" + constructor.getName(), InstrumentorUtil.makeVoid(constructor.getSignature()))) {
                String setReturnValueMethodName = InstrumentorUtil.getSetReturnValueMethodName((CtBehavior)constructor);
                constructor.insertAfter(setReturnValueMethodName + "(null);");
                constructor.insertAfter("post_" + constructor.getName() + "($$);");
            }
            for (CtField field : fields = targetClass.getDeclaredFields()) {
                if (!field.getName().startsWith("___contract") || !InstrumentorUtil.methodExistsInClass(field.getType(), "classInvariant", "()V")) continue;
                constructor.insertAfter(field.getName() + ".classInvariant();");
                constructor.insertAfter("net.sourceforge.c4j.ContractBase.classInvariantCheck(\"" + targetClass.getName() + "\");");
            }
            if (!InstrumentorUtil.fieldExistsInClass(targetClass, INITIALIZED_FLAG_VAR)) continue;
            constructor.insertAfter("___initialized = true;");
        }
    }

    private void addMemberField(CtClass targetClass, CtClass contractClass, int contractIndex) throws CannotCompileException {
        CtField contractReference = null;
        contractReference = InstrumentorUtil.oneArgConstructorExists(contractClass) ? CtField.make((String)("private " + contractClass.getName() + " ___contract" + contractIndex + " = new " + contractClass.getName() + "(this);"), (CtClass)targetClass) : CtField.make((String)("private " + contractClass.getName() + " ___contract" + contractIndex + " = new " + contractClass.getName() + "();"), (CtClass)targetClass);
        targetClass.addField(contractReference);
    }

    protected static void debug(String message) {
        if (Instrumentor.isDebug()) {
            System.out.println("||C4J|| Debug: " + message);
        }
    }

    protected static void info(String message) {
        if (Instrumentor.isInfo() || Instrumentor.isDebug()) {
            System.out.println("||C4J|| Info: " + message);
        }
    }

    protected static void warn(String message) {
        if (Instrumentor.isWarn() || Instrumentor.isInfo() || Instrumentor.isDebug()) {
            System.out.println("||C4J|| Warning: " + message);
        }
    }

    protected static void trace(String message) {
        System.out.println("||C4J|| Trace: " + message);
    }

    public static void error(String message) {
        System.err.println("||C4J|| Error: " + message);
    }

    private static boolean isDebug() {
        return "debug".equals(m_options.get("loglevel"));
    }

    private static boolean isInfo() {
        return "info".equals(m_options.get("loglevel"));
    }

    private static boolean isWarn() {
        return "warn".equals(m_options.get("loglevel"));
    }
}

