/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.c4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.c4j.Instrumentor;
import net.sourceforge.c4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContractBase<T> {
    private static List<Logger> s_loggers = new ArrayList<Logger>();
    private static ThreadLocal<List<Object>> m_returnValues;
    private static ThreadLocal<List<Map<String, Object>>> m_preConditionValues;
    protected T m_target;
    private static ThreadLocal<Set<String>> m_runningContracts;

    protected ContractBase() {
        Instrumentor.debug("Created " + this);
    }

    protected ContractBase(T target) {
        this();
        this.m_target = target;
    }

    protected static void setPreconditionValue(String name, Object value) {
        m_preConditionValues.get().get(m_preConditionValues.get().size() - 1).put(name, value);
    }

    protected static Object getPreconditionValue(String name) {
        return m_preConditionValues.get().get(m_preConditionValues.get().size() - 1).get(name);
    }

    protected static Object getReturnValue() {
        Object value = m_returnValues.get().get(m_returnValues.get().size() - 1);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogger(Logger logger) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            s_loggers.add(logger);
        }
        Instrumentor.info("Logger '" + logger.getClass().getName() + "' added.");
    }

    public Object getTargetField(String name) {
        Object fieldValue = null;
        try {
            Class<?> clazz = this.m_target.getClass();
            Field field = null;
            while (field == null && !clazz.equals(Object.class) && !clazz.isInterface()) {
                try {
                    field = clazz.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (field != null) {
                field.setAccessible(true);
                fieldValue = field.get(this.m_target);
            } else {
                Instrumentor.warn("Field '" + name + "' doesn't exist in '" + this.m_target.getClass().getName() + "'.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    public static void pushPreconditionValuesMap() {
        m_preConditionValues.get().add(new HashMap());
    }

    public static void popPreconditionValuesMap() {
        m_preConditionValues.get().remove(m_preConditionValues.get().size() - 1);
    }

    public static void pushReturnValue() {
        m_returnValues.get().add(null);
    }

    public static void setReturnValue(Object value) {
        m_returnValues.get().set(m_returnValues.get().size() - 1, value);
    }

    public static void popReturnValue() {
        m_returnValues.get().remove(m_returnValues.get().size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classInvariantCheck(String className) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            for (Logger logger : s_loggers) {
                logger.classInvariantCheck(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preConditionCheck(String className, String method, Object[] parameters) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            for (Logger logger : s_loggers) {
                logger.preConditionCheck(className, method, parameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postConditionCheck(String className, String method, Object[] parameters) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            for (Logger logger : s_loggers) {
                logger.postConditionCheck(className, method, parameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursivePostConditionNotChecked(String className, String method, Object[] parameters) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            for (Logger logger : s_loggers) {
                logger.recursivePostConditionNotChecked(className, method, parameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursivePreConditionNotChecked(String className, String method, Object[] parameters) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            for (Logger logger : s_loggers) {
                logger.recursivePreConditionNotChecked(className, method, parameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveInvariantNotChecked(String className) {
        List<Logger> list = s_loggers;
        synchronized (list) {
            for (Logger logger : s_loggers) {
                logger.recursiveInvariantNotChecked(className);
            }
        }
    }

    public void enterContract(String contractName) {
        m_runningContracts.get().add(contractName);
    }

    public void exitContract(String contractName) {
        m_runningContracts.get().remove(contractName);
    }

    public boolean runningContract(String contractName) {
        return m_runningContracts.get().contains(contractName);
    }

    static {
        m_preConditionValues = new ThreadLocal<List<Map<String, Object>>>(){

            @Override
            protected synchronized List<Map<String, Object>> initialValue() {
                return new LinkedList<Map<String, Object>>();
            }
        };
        m_returnValues = new ThreadLocal<List<Object>>(){

            @Override
            protected synchronized List<Object> initialValue() {
                return new LinkedList<Object>();
            }
        };
        m_runningContracts = new ThreadLocal<Set<String>>(){

            @Override
            protected synchronized Set<String> initialValue() {
                return new HashSet<String>();
            }
        };
    }
}

