/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.ui.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.projectusus.autotestsuite.AutoTestSuitePlugin;
import org.projectusus.autotestsuite.ui.internal.util.ISharedAutoTestSuiteImages;

public class AutoTestSuiteUIImages
implements ISharedAutoTestSuiteImages {
    private static URL baseUrl;
    private static final ISharedAutoTestSuiteImages _instance;
    private ImageRegistry imageRegistry;
    private static final String OBJECT = "obj16/";

    static {
        _instance = new AutoTestSuiteUIImages();
        String pathPrefix = "icons/";
        try {
            Bundle bundle = AutoTestSuitePlugin.getDefault().getBundle();
            baseUrl = new URL(bundle.getEntry("/"), pathPrefix);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private AutoTestSuiteUIImages() {
    }

    public static ISharedAutoTestSuiteImages getSharedImages() {
        return _instance;
    }

    @Override
    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    @Override
    public ImageDescriptor getDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    private void declareImages() {
        this.declare(OBJ_JUNIT_3, "obj16/junit3.gif");
        this.declare(OBJ_JUNIT_4, "obj16/junit4.gif");
        this.declare(OBJ_TAB, "obj16/tab.gif");
    }

    private void declare(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)this.makeIconFileURL(path));
        }
        catch (MalformedURLException exception) {
            AutoTestSuitePlugin.log(exception);
        }
        this.imageRegistry.put(key, desc);
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.initializeImageRegistry();
        }
        return this.imageRegistry;
    }

    private ImageRegistry initializeImageRegistry() {
        this.imageRegistry = new ImageRegistry(Display.getDefault());
        this.declareImages();
        return this.imageRegistry;
    }

    private URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (baseUrl == null) {
            throw new MalformedURLException();
        }
        return new URL(baseUrl, iconPath);
    }
}

