/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.ui.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.projectusus.autotestsuite.core.internal.AllJavaProjectsInWorkspace;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationConstants;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationReader;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationWriter;
import org.projectusus.autotestsuite.ui.internal.CheckedProjectsViewer;
import org.projectusus.autotestsuite.ui.internal.MassSelectionComposite;
import org.projectusus.autotestsuite.ui.internal.util.AutoTestSuiteUIImages;
import org.projectusus.autotestsuite.ui.internal.util.ISharedAutoTestSuiteImages;

public class ExtendedJUnitLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Text projectText;
    private Button keepRunning;
    private ComboViewer testLoader;
    private CheckedProjectsViewer checkedProjectsViewer;

    public String getName() {
        return "Test Projects";
    }

    public Image getImage() {
        return AutoTestSuiteUIImages.getSharedImages().getImage(ISharedAutoTestSuiteImages.OBJ_TAB);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)composite);
        this.createRootProjectSection(composite);
        this.createSpacer(composite);
        this.createCheckedProjectsSection(composite);
        this.createSpacer(composite);
        this.createTestLoaderGroup(composite);
        this.createSpacer(composite);
        this.createKeepRunningGroup(composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createCheckedProjectsSection(Composite composite) {
        Label label = this.createLabel(composite, "&Selected Projects:");
        GridData data = (GridData)label.getLayoutData();
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        this.checkedProjectsViewer = new CheckedProjectsViewer(composite);
        this.checkedProjectsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExtendedJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        new MassSelectionComposite(composite){

            @Override
            void onSelectAll() {
                ExtendedJUnitLaunchConfigurationTab.this.checkedProjectsViewer.setAllChecked(true);
                ExtendedJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }

            @Override
            void onDeselectAll() {
                ExtendedJUnitLaunchConfigurationTab.this.checkedProjectsViewer.setAllChecked(false);
                ExtendedJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    private void createRootProjectSection(Composite composite) {
        this.createLabel(composite, "Root &Project:");
        this.projectText = new Text(composite, 2060);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ExtendedJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                ExtendedJUnitLaunchConfigurationTab.this.checkedProjectsViewer.updateCheckedProjects(ExtendedJUnitLaunchConfigurationTab.this.getRootProject());
            }
        });
        Button projectButton = new Button(composite, 8);
        projectButton.setText("&Browse...");
        projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ExtendedJUnitLaunchConfigurationTab.this.handleProjectButtonSelected();
            }
        });
        this.setButtonGridData(projectButton);
    }

    private IJavaProject getRootProject() {
        return ExtendedJUnitLaunchConfigurationConstants.toProject(this.projectText.getText().trim());
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        this.projectText.setText(project.getElementName());
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Root Project Selection");
        dialog.setMessage("Choose a Root Project:");
        dialog.setElements((Object[])new AllJavaProjectsInWorkspace().find());
        IJavaProject javaProject = this.getRootProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.heightHint = 1;
        label.setLayoutData((Object)data);
    }

    private void createKeepRunningGroup(Composite composite) {
        this.keepRunning = new Button(composite, 32);
        this.keepRunning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.keepRunning.setText("&Keep JUnit running after a test run when debugging");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.keepRunning.setLayoutData((Object)data);
    }

    private void createTestLoaderGroup(Composite composite) {
        this.createLabel(composite, "&Test runner:");
        this.testLoader = new ComboViewer(composite, 12);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.testLoader.getCombo().setLayoutData((Object)data);
        this.testLoader.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.testLoader.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((TestKind)element).getDisplayName();
            }
        });
        this.testLoader.setInput((Object)TestKindRegistry.getDefault().getAllKinds());
        this.testLoader.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExtendedJUnitLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private Label createLabel(Composite comp, String text) {
        Label label = new Label(comp, 0);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalIndent = 0;
        label.setLayoutData((Object)data);
        return label;
    }

    private IJavaElement getContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IJavaElement) {
                    return (IJavaElement)obj;
                }
                if (obj instanceof IResource) {
                    IJavaElement je = JavaCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = JavaCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input = part.getEditorInput();
                return (IJavaElement)input.getAdapter(IJavaElement.class);
            }
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        ExtendedJUnitLaunchConfigurationWriter writer = new ExtendedJUnitLaunchConfigurationWriter(config);
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(writer, javaElement);
            writer.setCheckedProjects(Arrays.asList(new AllJavaProjectsInWorkspace().find()));
        } else {
            writer.setProjectName("");
            writer.setTestContainer("");
        }
        this.initializeTestAttributes(javaElement, writer);
    }

    private void initializeTestAttributes(IJavaElement javaElement, ExtendedJUnitLaunchConfigurationWriter writer) {
        if (javaElement != null && javaElement.getElementType() < 5) {
            this.initializeTestContainer(writer, javaElement);
        } else {
            this.initializeTestType(writer, javaElement);
        }
    }

    private void initializeTestContainer(ExtendedJUnitLaunchConfigurationWriter config, IJavaElement javaElement) {
        config.setTestContainer(javaElement.getHandleIdentifier());
        this.initializeName(config, javaElement.getElementName());
    }

    private void initializeName(ExtendedJUnitLaunchConfigurationWriter config, String inputName) {
        if (inputName == null) {
            return;
        }
        if (inputName.length() > 0) {
            int index = inputName.lastIndexOf(46);
            String name = inputName;
            if (index > 0) {
                name = inputName.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.renameTo(inputName);
        }
    }

    private void initializeTestType(ExtendedJUnitLaunchConfigurationWriter config, IJavaElement javaElement) {
        if (javaElement instanceof ISourceReference) {
            config.setTestKind(TestKindRegistry.getContainerTestKind((IJavaElement)javaElement).getId());
        }
        config.setUnusedAttributesToDefaults();
    }

    private void initializeJavaProject(ExtendedJUnitLaunchConfigurationWriter config, IJavaElement javaElement) {
        IJavaProject javaProject = javaElement.getJavaProject();
        String name = null;
        if (javaProject != null && javaProject.exists()) {
            name = javaProject.getElementName();
        }
        config.setProjectName(name);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        ExtendedJUnitLaunchConfigurationReader reader = new ExtendedJUnitLaunchConfigurationReader(config);
        this.projectText.setText(reader.getProjectName());
        this.checkedProjectsViewer.setCheckedElements(reader.getCheckedProjects());
        this.keepRunning.setSelection(reader.isKeepRunning());
        this.testLoader.setSelection((ISelection)new StructuredSelection((Object)reader.getTestKind()));
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        ExtendedJUnitLaunchConfigurationWriter writer = new ExtendedJUnitLaunchConfigurationWriter(config);
        writer.setUnusedAttributesToDefaults();
        writer.setProjectName(this.projectText.getText());
        writer.setTestContainer(this.projectText.getText());
        writer.setKeepRunning(this.keepRunning.getSelection());
        this.applyCheckedProjects(writer);
        this.applyTestKind(writer);
    }

    private void applyTestKind(ExtendedJUnitLaunchConfigurationWriter writer) {
        IStructuredSelection testKindSelection = (IStructuredSelection)this.testLoader.getSelection();
        if (!testKindSelection.isEmpty()) {
            writer.setTestKind((ITestKind)((TestKind)testKindSelection.getFirstElement()));
        }
    }

    private void applyCheckedProjects(ExtendedJUnitLaunchConfigurationWriter writer) {
        List checkedProjects = Lists.transform(Arrays.asList(this.checkedProjectsViewer.getCheckedElements()), (Function)new Function<Object, IJavaProject>(){

            public IJavaProject apply(Object object) {
                return (IJavaProject)object;
            }
        });
        writer.setCheckedProjects(checkedProjects);
    }
}

