/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.ui.internal;

import java.util.LinkedHashSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.projectusus.autotestsuite.core.internal.AllJavaProjectsInWorkspace;
import org.projectusus.autotestsuite.core.internal.RequiredJavaProjects;

class CheckedProjectsViewer
extends CheckboxTableViewer {
    CheckedProjectsViewer(Composite parent) {
        super(new Table(parent, 2080));
        this.getControl().setLayoutData((Object)new GridData(1808));
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        this.setInput(new AllJavaProjectsInWorkspace().find());
    }

    void updateCheckedProjects(IJavaProject root) {
        Object[] checked = this.getCheckedElements();
        LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        if (root != null) {
            AllJavaProjectsInWorkspace allProjects = new AllJavaProjectsInWorkspace();
            projects.addAll(new RequiredJavaProjects(allProjects).findFor(root));
        }
        this.setInput(projects);
        this.setCheckedElements(checked);
    }
}

