/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal.config;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.projectusus.autotestsuite.core.internal.config.MockInitializer;

public class Mockery
implements MethodRule {
    private final Multimap<Class<?>, MockInitializer<?, ?>> initializers = LinkedListMultimap.create();

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                MockitoAnnotations.initMocks((Object)target);
                base.evaluate();
            }
        };
    }

    public Mockery with(MockInitializer<?, ?> initializer) {
        this.initializers.put(initializer.classToMock(), initializer);
        return this;
    }

    public <T, V> T mock(Class<T> clazz, V value) {
        T mock = this.mock(clazz);
        Collection classInitializers = this.initializers.get(clazz);
        if (classInitializers != null) {
            for (MockInitializer initializer : classInitializers) {
                this.cast(initializer).prepare(mock, value);
            }
        }
        return mock;
    }

    public <T> T mock(Class<T> clazz) {
        return (T)Mockito.mock(clazz);
    }

    private <T, V> MockInitializer<T, V> cast(MockInitializer<?, ?> initializer) {
        return initializer;
    }
}

