/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal.config;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationWriter;
import org.projectusus.autotestsuite.core.internal.config.JavaProjectNamer;
import org.projectusus.autotestsuite.core.internal.config.Mockery;
import org.projectusus.autotestsuite.core.internal.config.TestKindIdInitializer;

public class ExtendedJUnitLaunchConfigurationWriterTest {
    @Rule
    public Mockery mockery = new Mockery().with(new TestKindIdInitializer()).with(new JavaProjectNamer());
    @Mock
    public ILaunchConfigurationWorkingCopy config;
    private ExtendedJUnitLaunchConfigurationWriter writer;

    @Before
    public void createWriter() {
        this.writer = new ExtendedJUnitLaunchConfigurationWriter(this.config);
    }

    @Test
    public void setProjectName() {
        this.writer.setProjectName("Usus");
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "Usus");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void setTestContainer() {
        this.writer.setTestContainer("unused");
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("org.eclipse.jdt.junit.CONTAINER", "unused");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void setUnusedAttributesToDefaults() {
        this.writer.setUnusedAttributesToDefaults();
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void setKeepRunning() throws Exception {
        this.writer.setKeepRunning(true);
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void setTestKind() throws Exception {
        this.writer.setTestKind(this.mockery.mock(ITestKind.class, "123"));
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("org.eclipse.jdt.junit.TEST_KIND", "123");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void setDefaultTestKind() {
        this.writer.setDefaultTestKind();
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("org.eclipse.jdt.junit.TEST_KIND", "org.eclipse.jdt.junit.loader.junit4");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void renameTo() {
        this.writer.renameTo("foo");
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).rename("foo");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void setCheckedProjects() {
        this.writer.setCheckedProjects(Arrays.asList(this.mockery.mock(IJavaProject.class, "a"), this.mockery.mock(IJavaProject.class, "b")));
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("ATTR_CHECKED_PROJECTS", "a/b");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }

    @Test
    public void emptyValueWithoutAnyCheckedProjects() {
        this.writer.setCheckedProjects(Collections.emptyList());
        ((ILaunchConfigurationWorkingCopy)Mockito.verify((Object)this.config)).setAttribute("ATTR_CHECKED_PROJECTS", "");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.config});
    }
}

