/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal.config;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class ExtendedJUnitLaunchConfigurationWriter {
    private final ILaunchConfigurationWorkingCopy config;

    public ExtendedJUnitLaunchConfigurationWriter(ILaunchConfigurationWorkingCopy config) {
        this.config = config;
    }

    public void setCheckedProjects(Collection<IJavaProject> checkedProjects) {
        String value = Joiner.on((char)'/').join(Iterables.transform(checkedProjects, (Function)new Function<Object, String>(){

            public String apply(Object project) {
                return ((IJavaProject)project).getElementName();
            }
        }));
        this.config.setAttribute("ATTR_CHECKED_PROJECTS", value);
    }

    public void setTestKind(String testKindId) {
        this.config.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKindId);
    }

    public void setProjectName(String name) {
        this.config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
    }

    public void setTestContainer(String identifier) {
        this.config.setAttribute("org.eclipse.jdt.junit.CONTAINER", identifier);
    }

    public void setUnusedAttributesToDefaults() {
        this.config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        this.config.setAttribute("org.eclipse.jdt.junit.TESTNAME", "");
    }

    public void setKeepRunning(boolean keepRunning) {
        this.config.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", keepRunning);
    }

    public void setTestKind(ITestKind testKind) {
        this.config.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKind.getId());
    }

    public void setDefaultTestKind() {
        this.setTestKind("org.eclipse.jdt.junit.loader.junit4");
    }

    public void renameTo(String inputName) {
        this.config.rename(inputName);
    }
}

