/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal.config;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationReader;
import org.projectusus.autotestsuite.core.internal.config.JavaProjectNamer;
import org.projectusus.autotestsuite.core.internal.config.Mockery;

public class ExtendedJUnitLaunchConfigurationReaderTest {
    private static final Status DUMMY_STATUS = new Status(0, "xx", "xx");
    @Rule
    public Mockery mockery = new Mockery().with(new JavaProjectNamer());
    @Mock
    private ILaunchConfiguration config;
    private ExtendedJUnitLaunchConfigurationReader reader;
    private final Function<String, IJavaProject> converter = new Function<String, IJavaProject>(){

        public IJavaProject apply(String name) {
            return ExtendedJUnitLaunchConfigurationReaderTest.this.mockery.mock(IJavaProject.class, name);
        }
    };

    @Before
    public void createReader() {
        this.reader = new ExtendedJUnitLaunchConfigurationReader(this.config);
    }

    @Test
    public void parseCheckedProjects() throws Exception {
        this.set("ATTR_CHECKED_PROJECTS", "xxx/y/zz");
        Assert.assertEquals(Arrays.asList("xxx", "y", "zz"), JavaProjectNamer.collectNames(this.reader.getCheckedProjects(this.converter)));
    }

    @Test
    public void noCheckedProjectsForEmptyValue() throws Exception {
        this.set("ATTR_CHECKED_PROJECTS", "");
        Assert.assertEquals(Collections.emptyList(), JavaProjectNamer.collectNames(this.reader.getCheckedProjects(this.converter)));
    }

    @Test
    public void noCheckedProjectsInCaseOfError() throws Exception {
        this.throwCoreExceptionOn(this.config.getAttribute("ATTR_CHECKED_PROJECTS", ""));
        Assert.assertEquals(Collections.emptyList(), JavaProjectNamer.collectNames(this.reader.getCheckedProjects(this.converter)));
    }

    @Test
    public void projectName() throws Exception {
        this.set(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "Usus");
        Assert.assertThat((Object)this.reader.getProjectName(), (Matcher)CoreMatchers.is((Object)"Usus"));
    }

    @Test
    public void emptyProjectNameInCaseOfError() throws Exception {
        this.throwCoreExceptionOn(this.config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
        Assert.assertThat((Object)this.reader.getProjectName(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void keepRunning() throws Exception {
        this.set("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", true);
        Assert.assertTrue((boolean)this.reader.isKeepRunning());
    }

    @Test
    public void noKeepRunningInCaseOfError() throws Exception {
        this.throwCoreExceptionOn(this.config.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false));
        Assert.assertFalse((boolean)this.reader.isKeepRunning());
    }

    private <T> void throwCoreExceptionOn(T call) {
        Mockito.when(call).thenThrow(new Throwable[]{new CoreException((IStatus)DUMMY_STATUS)});
    }

    private void set(String key, String value) throws CoreException {
        Mockito.when((Object)this.config.getAttribute(key, "")).thenReturn((Object)value);
    }

    private void set(String key, boolean value) throws CoreException {
        Mockito.when((Object)this.config.getAttribute(key, false)).thenReturn((Object)value);
    }
}

