/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal.config;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.projectusus.autotestsuite.AutoTestSuitePlugin;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationConstants;

public class ExtendedJUnitLaunchConfigurationReader {
    private final ILaunchConfiguration config;

    public ExtendedJUnitLaunchConfigurationReader(ILaunchConfiguration config) {
        this.config = config;
    }

    public boolean isKeepRunning() {
        try {
            return this.config.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        }
        catch (CoreException exception) {
            AutoTestSuitePlugin.logStatusOf(exception);
            return false;
        }
    }

    public ITestKind getTestKind() {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind((ILaunchConfiguration)this.config);
        if (testKind.isNull()) {
            testKind = TestKindRegistry.getDefault().getKind("org.eclipse.jdt.junit.loader.junit4");
        }
        return testKind;
    }

    public String getProjectName() {
        try {
            return this.config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException exception) {
            AutoTestSuitePlugin.logStatusOf(exception);
            return "";
        }
    }

    private IJavaProject[] loadCheckedProjects(Function<String, IJavaProject> converter) throws CoreException {
        String value = this.config.getAttribute("ATTR_CHECKED_PROJECTS", "");
        if (Strings.isNullOrEmpty((String)value)) {
            return new IJavaProject[0];
        }
        Iterable split = Splitter.on((char)'/').split((CharSequence)value);
        Iterable projects = Iterables.transform((Iterable)split, converter);
        return (IJavaProject[])Iterables.toArray((Iterable)projects, IJavaProject.class);
    }

    public IJavaProject[] getCheckedProjects() {
        return this.getCheckedProjects(new Function<String, IJavaProject>(){

            public IJavaProject apply(String name) {
                return ExtendedJUnitLaunchConfigurationConstants.toProject(name);
            }
        });
    }

    public IJavaProject[] getCheckedProjects(Function<String, IJavaProject> converter) {
        try {
            return this.loadCheckedProjects(converter);
        }
        catch (CoreException exception) {
            AutoTestSuitePlugin.logStatusOf(exception);
            return new IJavaProject[0];
        }
    }
}

