/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal.config;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.AssertionVMArg;
import org.eclipse.jdt.internal.junit.launcher.JUnitMigrationDelegate;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.projectusus.autotestsuite.core.internal.AllJavaProjectsInWorkspace;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationConstants;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationWriter;

public class ExtendedJUnitLaunchConfigurationCreator {
    public ILaunchConfiguration createAndSaveNewConfig(IJavaProject project) throws CoreException {
        return this.createNewConfig(project).doSave();
    }

    public ILaunchConfigurationWorkingCopy createNewConfig(IJavaProject root) throws CoreException {
        return this.createNewConfig(root, Arrays.asList(new AllJavaProjectsInWorkspace().find()));
    }

    public ILaunchConfigurationWorkingCopy createNewConfig(IJavaProject root, Collection<IJavaProject> projects) throws CoreException {
        String name = JavaElementLabels.getTextLabel((Object)root, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
        String uniqueName = ExtendedJUnitLaunchConfigurationConstants.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
        ILaunchConfigurationWorkingCopy config = ExtendedJUnitLaunchConfigurationConstants.getLaunchConfigurationType().newInstance(null, uniqueName);
        return this.fillAttributes(root, config, projects);
    }

    private ILaunchConfigurationWorkingCopy fillAttributes(IJavaProject project, ILaunchConfigurationWorkingCopy config, Collection<IJavaProject> projects) throws CoreException {
        ExtendedJUnitLaunchConfigurationWriter writer = new ExtendedJUnitLaunchConfigurationWriter(config);
        writer.setUnusedAttributesToDefaults();
        writer.setProjectName(project.getElementName());
        writer.setDefaultTestKind();
        writer.setCheckedProjects(projects);
        writer.setKeepRunning(false);
        writer.setTestContainer(project.getElementName());
        JUnitMigrationDelegate.mapResources((ILaunchConfigurationWorkingCopy)config);
        AssertionVMArg.setArgDefault((ILaunchConfigurationWorkingCopy)config);
        return config;
    }
}

