/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.mockito.Mockito;
import org.projectusus.autotestsuite.core.internal.IAllJavaProjects;

abstract class TestsWithProjectDependencies {
    private final Map<IJavaProject, Set<String>> projects = new HashMap<IJavaProject, Set<String>>();

    TestsWithProjectDependencies() {
    }

    IAllJavaProjects projects() {
        return new IAllJavaProjects(){

            @Override
            public IJavaProject[] find() {
                Set all = TestsWithProjectDependencies.this.projects.keySet();
                return all.toArray(new IJavaProject[all.size()]);
            }
        };
    }

    IJavaProject addProject(String name) throws JavaModelException {
        IJavaProject project = (IJavaProject)Mockito.mock(IJavaProject.class);
        Mockito.when((Object)project.getElementName()).thenReturn((Object)name);
        Mockito.when((Object)project.toString()).thenReturn((Object)("Mock project: " + name));
        this.projects.put(project, new HashSet());
        this.wireMockDependencies(project);
        return project;
    }

    void addDependency(IJavaProject project, IJavaProject dependency) throws JavaModelException {
        this.projects.get(project).add(dependency.getElementName());
        this.wireMockDependencies(project);
    }

    void wireMockDependencies(IJavaProject project) throws JavaModelException {
        Mockito.when((Object)project.getRequiredProjectNames()).thenReturn((Object)this.allDependencyNamesFor(project));
    }

    String[] allDependencyNamesFor(IJavaProject project) {
        Set<String> dependencies = this.projects.get(project);
        return dependencies.toArray(new String[dependencies.size()]);
    }
}

