/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal;

import org.eclipse.jdt.core.IJavaProject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.projectusus.autotestsuite.core.internal.RequiredJavaProjects;
import org.projectusus.autotestsuite.core.internal.TestsWithProjectDependencies;

public class RequiredJavaProjectsTest
extends TestsWithProjectDependencies {
    private final RequiredJavaProjects finder = new RequiredJavaProjects(this.projects());

    @Test
    public void dependencyLessProjectFindsNothing() throws Exception {
        IJavaProject project = this.addProject("p1");
        Assert.assertThat((Object)this.finder.findFor(project).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)project));
    }

    @Test
    public void singleDependencyIsFound() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependency = this.addProject("p2");
        this.addDependency(project, dependency);
        Assert.assertThat((Object)this.finder.findFor(project).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)project));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)dependency));
    }

    @Test
    public void multipleDependenciesAreFound() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependencyLeft = this.addProject("p2");
        this.addDependency(project, dependencyLeft);
        IJavaProject dependencyRight = this.addProject("p3");
        this.addDependency(project, dependencyRight);
        Assert.assertThat((Object)this.finder.findFor(project).size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)project));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)dependencyLeft));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)dependencyRight));
    }

    @Test
    public void indirectDependencyIsFound() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject directDependency = this.addProject("p2");
        this.addDependency(project, directDependency);
        IJavaProject indirectDependency = this.addProject("p3");
        this.addDependency(directDependency, indirectDependency);
        Assert.assertThat((Object)this.finder.findFor(project).size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)project));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)directDependency));
        Assert.assertThat(this.finder.findFor(project), (Matcher)JUnitMatchers.hasItem((Object)indirectDependency));
    }
}

