/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.projectusus.autotestsuite.AutoTestSuitePlugin;
import org.projectusus.autotestsuite.core.internal.IAllJavaProjects;

public class RequiredJavaProjects {
    private final IAllJavaProjects allJavaProjects;

    public RequiredJavaProjects(IAllJavaProjects allJavaProjects) {
        this.allJavaProjects = allJavaProjects;
    }

    public Collection<IJavaProject> findFor(IJavaProject project) {
        LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        projects.add(project);
        try {
            String[] stringArray = project.getRequiredProjectNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                IJavaProject required = this.findJavaProject(name);
                projects.addAll(this.findFor(required));
                ++n2;
            }
        }
        catch (JavaModelException exception) {
            AutoTestSuitePlugin.logStatusOf((CoreException)((Object)exception));
        }
        return projects;
    }

    private IJavaProject findJavaProject(String name) {
        IJavaProject[] iJavaProjectArray = this.allJavaProjects.find();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            if (name.equals(project.getElementName())) {
                return project;
            }
            ++n2;
        }
        throw new IllegalStateException(this.formulateComplaint(name));
    }

    private String formulateComplaint(String name) {
        String pattern = "Project claims to have dependency ''{0}'' which is not found in workspace.";
        return MessageFormat.format(pattern, name);
    }
}

