/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.projectusus.autotestsuite.core.internal.AllJavaProjectsInWorkspace;
import org.projectusus.autotestsuite.core.internal.RequiredJavaProjects;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationConstants;
import org.projectusus.autotestsuite.core.internal.config.ExtendedJUnitLaunchConfigurationReader;

public class ExtendedJUnitLaunchConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    protected IMember[] evaluateTests(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        return this.evaluateTests(new ExtendedJUnitLaunchConfigurationReader(config), monitor);
    }

    private IMember[] evaluateTests(ExtendedJUnitLaunchConfigurationReader config, IProgressMonitor monitor) throws CoreException {
        Collection<IJavaProject> projects = this.collectProjects(config);
        Set<? extends IMember> result = this.collectTests(config, projects, monitor);
        this.checkResult(config, result);
        return result.toArray(new IMember[result.size()]);
    }

    private Set<? extends IMember> collectTests(ExtendedJUnitLaunchConfigurationReader config, Collection<IJavaProject> projects, IProgressMonitor monitor) throws CoreException {
        HashSet result = new HashSet();
        ITestKind testKind = config.getTestKind();
        monitor.beginTask("Looking for tests", projects.size());
        for (IJavaProject project : projects) {
            monitor.subTask(project.getElementName());
            testKind.getFinder().findTestsInContainer((IJavaElement)project, result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
        return result;
    }

    private Collection<IJavaProject> collectProjects(ExtendedJUnitLaunchConfigurationReader config) {
        IJavaProject project = ExtendedJUnitLaunchConfigurationConstants.toProject(config.getProjectName());
        LinkedList<IJavaProject> projects = new LinkedList<IJavaProject>(this.findRequired(project));
        IJavaProject[] checkedProjects = config.getCheckedProjects();
        projects.retainAll(Arrays.asList(checkedProjects));
        return projects;
    }

    private Collection<IJavaProject> findRequired(IJavaProject project) {
        AllJavaProjectsInWorkspace allProjects = new AllJavaProjectsInWorkspace();
        return new RequiredJavaProjects(allProjects).findFor(project);
    }

    private void checkResult(ExtendedJUnitLaunchConfigurationReader config, Set<? extends IMember> result) throws CoreException {
        if (result.isEmpty()) {
            String pattern = "No tests found with test runner ''{0}''.";
            String message = MessageFormat.format(pattern, config.getTestKind().getDisplayName());
            this.abort(message, null, 101);
        }
    }
}

