/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jdt.core.IJavaProject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.projectusus.autotestsuite.core.internal.CommonDependencyRoot;
import org.projectusus.autotestsuite.core.internal.TestsWithProjectDependencies;

public class CommonDependencyRootTest
extends TestsWithProjectDependencies {
    private final CommonDependencyRoot finder = new CommonDependencyRoot(this.projects());

    @Test
    public void noneFoundForEmpty() {
        Assert.assertThat((Object)this.finder.findFor(new HashSet<IJavaProject>()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void singleProjectFindsItself() throws Exception {
        IJavaProject project = this.addProject("p1");
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(project)), (Matcher)CoreMatchers.is((Object)project));
    }

    @Test
    public void dependentProjectFindsItself() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependency = this.addProject("p2");
        this.addDependency(project, dependency);
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(project)), (Matcher)CoreMatchers.is((Object)project));
    }

    @Test
    public void dependencyFindsItself() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependency = this.addProject("p2");
        this.addDependency(project, dependency);
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(dependency)), (Matcher)CoreMatchers.is((Object)dependency));
    }

    @Test
    public void dependencyFindsDependent() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependency = this.addProject("p2");
        this.addDependency(project, dependency);
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(project, dependency)), (Matcher)CoreMatchers.is((Object)project));
    }

    @Test
    public void directRootIsFound() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependencyLeft = this.addProject("p2");
        this.addDependency(project, dependencyLeft);
        IJavaProject dependencyRight = this.addProject("p3");
        this.addDependency(project, dependencyRight);
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(dependencyLeft, dependencyRight)), (Matcher)CoreMatchers.is((Object)project));
    }

    @Test
    public void indirectRootIsFound() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependencyLeft = this.addProject("p2");
        this.addDependency(project, dependencyLeft);
        IJavaProject dependencyRight = this.addProject("p3");
        this.addDependency(project, dependencyRight);
        IJavaProject dependencyBottom = this.addProject("p4");
        this.addDependency(dependencyRight, dependencyBottom);
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(dependencyLeft, dependencyBottom)), (Matcher)CoreMatchers.is((Object)project));
    }

    @Test
    public void intermediateRootIsFound() throws Exception {
        IJavaProject uberRoot = this.addProject("p0");
        IJavaProject project = this.addProject("p1");
        this.addDependency(uberRoot, project);
        IJavaProject dependencyLeft = this.addProject("p2");
        this.addDependency(project, dependencyLeft);
        IJavaProject dependencyRight = this.addProject("p3");
        this.addDependency(project, dependencyRight);
        IJavaProject dependencyBottom = this.addProject("p4");
        this.addDependency(dependencyRight, dependencyBottom);
        IJavaProject result = this.finder.findFor(Arrays.asList(dependencyLeft, dependencyBottom));
        Assert.assertThat((Object)result, (Matcher)JUnitMatchers.either((Matcher)CoreMatchers.is((Object)uberRoot)).or(CoreMatchers.is((Object)project)));
    }

    @Test
    public void unrelatedProjectsFindNothing() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject unrelatedProject = this.addProject("p2");
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(project, unrelatedProject)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void disconnectedDependencyGraphsFindNothing() throws Exception {
        IJavaProject project = this.addProject("p1");
        IJavaProject dependency = this.addProject("p2");
        this.addDependency(project, dependency);
        IJavaProject unrelatedProject = this.addProject("p3");
        Assert.assertThat((Object)this.finder.findFor(Arrays.asList(dependency, unrelatedProject)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

