/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.autotestsuite.core.internal;

import java.util.Collection;
import org.eclipse.jdt.core.IJavaProject;
import org.projectusus.autotestsuite.core.internal.IAllJavaProjects;
import org.projectusus.autotestsuite.core.internal.RequiredJavaProjects;

public class CommonDependencyRoot {
    private final RequiredJavaProjects requiredProjectsFinder;
    private final IAllJavaProjects allProjects;

    public CommonDependencyRoot(IAllJavaProjects allProjects) {
        this.allProjects = allProjects;
        this.requiredProjectsFinder = new RequiredJavaProjects(allProjects);
    }

    public IJavaProject findFor(Collection<IJavaProject> projects) {
        ProjectRank result = new ProjectRank();
        IJavaProject[] iJavaProjectArray = this.allProjects.find();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            Collection<IJavaProject> requiredProjects = this.requiredProjectsFinder.findFor(project);
            if (requiredProjects.containsAll(projects)) {
                result.update(project, requiredProjects.size());
            }
            ++n2;
        }
        return result.getProject();
    }

    public boolean existsFor(Collection<IJavaProject> projects) {
        return this.findFor(projects) != null;
    }

    class ProjectRank {
        private int size;
        private IJavaProject project;

        ProjectRank() {
        }

        IJavaProject getProject() {
            return this.project;
        }

        void update(IJavaProject project, int size) {
            if (this.isMoreInterestingThanPreviouslyFoundResult(size)) {
                this.size = size;
                this.project = project;
            }
        }

        private boolean isMoreInterestingThanPreviouslyFoundResult(int size) {
            return this.project == null || size < this.size;
        }
    }
}

