/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.views;

import java.util.Set;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.projectusus.core.IUsusModelListener;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.ui.dependencygraph.colorProvider.PackageEdgeColorProvider;
import org.projectusus.ui.dependencygraph.common.DependencyGraphModel;
import org.projectusus.ui.dependencygraph.common.DependencyGraphView;
import org.projectusus.ui.dependencygraph.common.DependencyGraphViewer;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;
import org.projectusus.ui.dependencygraph.nodes.PackageRepresenter;

public class PackageGraphView
extends DependencyGraphView {
    public static final String VIEW_ID = "org.projectusus.ui.dependencygraph.PackageGraphView";
    private static final String ONLY_IN_CYCLES = "Only cyclic dependencies";
    private static final DependencyGraphModel packageGraphModel = new DependencyGraphModel(){

        @Override
        protected Set<? extends GraphNode> getRefreshedNodes() {
            return PackageRepresenter.getAllPackages();
        }
    };
    private static final PackageEdgeColorProvider packageEdgeColorProvider = new PackageEdgeColorProvider();
    private boolean highlightStrongConnections = false;
    private final IUsusModelListener listener = new IUsusModelListener(){

        public void ususModelChanged() {
            packageEdgeColorProvider.calculatePackageRelations();
        }
    };

    public PackageGraphView() {
        super(VIEW_ID, packageGraphModel, packageEdgeColorProvider);
        UsusModelProvider.ususModel().addUsusModelListener(this.listener);
    }

    @Override
    public void dispose() {
        UsusModelProvider.ususModel().removeUsusModelListener(this.listener);
        super.dispose();
    }

    @Override
    public String getFilenameForScreenshot() {
        return "usus-package-graph";
    }

    @Override
    protected String getRestrictingCheckboxLabelName() {
        return ONLY_IN_CYCLES;
    }

    @Override
    protected Control createAdditionalWidgets(Composite filterArea) {
        Composite composite = new Composite(filterArea, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).spacing(10, 0).create());
        this.createRestrictingCheckBox(composite);
        this.createHighlightCheckbox(composite);
        return composite;
    }

    private void createHighlightCheckbox(Composite composite) {
        Button checkbox = new Button(composite, 32);
        checkbox.setText("Highlight strong connections");
        checkbox.setToolTipText("Saturates edges based on the number of relations among packages");
        checkbox.addSelectionListener((SelectionListener)this.highlightCheckboxSelectionAdapter());
        checkbox.setSelection(this.highlightStrongConnections);
    }

    private SelectionAdapter highlightCheckboxSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(final SelectionEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Button source = (Button)e.getSource();
                        PackageGraphView.this.highlightStrongConnections = source.getSelection();
                        DependencyGraphViewer graphViewer = (DependencyGraphViewer)PackageGraphView.this.getZoomableViewer();
                        graphViewer.setHighlightStrongConnections(PackageGraphView.this.highlightStrongConnections);
                        graphViewer.refresh();
                    }
                });
            }
        };
    }
}

