/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.views;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.projectusus.ui.dependencygraph.colorProvider.ClassEdgeColorProvider;
import org.projectusus.ui.dependencygraph.common.DependencyGraphModel;
import org.projectusus.ui.dependencygraph.common.DependencyGraphView;
import org.projectusus.ui.dependencygraph.nodes.ClassRepresenter;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderFilterExtension;

public class ClassGraphView
extends DependencyGraphView {
    public static final String VIEW_ID = "org.projectusus.ui.dependencygraph.ClassGraphView";
    private static final String ONLY_CROSS_PACKAGE = "Only cross-package relations";
    private static final DependencyGraphModel classGraphModel = new DependencyGraphModel(){

        @Override
        protected Set<? extends GraphNode> getRefreshedNodes() {
            return ClassRepresenter.getAllClassRepresenters();
        }
    };
    private final ToolBarManager toolBarManager = new ToolBarManager(131328);
    private final SourceFolderFilterExtension sourceFolderFilterExtension = new SourceFolderFilterExtension(this);
    private Composite additionalWidgetsComposite;

    public ClassGraphView() {
        super(VIEW_ID, classGraphModel, new ClassEdgeColorProvider());
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.sourceFolderFilterExtension.initialize();
    }

    @Override
    protected Collection<? extends ViewerFilter> createAdditionalFilters() {
        return Collections.singleton(this.sourceFolderFilterExtension.getFilter());
    }

    @Override
    public String getFilenameForScreenshot() {
        return "usus-class-graph";
    }

    @Override
    protected String getRestrictingCheckboxLabelName() {
        return ONLY_CROSS_PACKAGE;
    }

    @Override
    public void dispose() {
        this.sourceFolderFilterExtension.dispose();
        this.toolBarManager.dispose();
        super.dispose();
    }

    @Override
    protected Control createAdditionalWidgets(Composite filterArea) {
        this.additionalWidgetsComposite = new Composite(filterArea, 0);
        this.additionalWidgetsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 0).create());
        this.createAdditionalToolbar(this.additionalWidgetsComposite);
        this.createRestrictingCheckBox(this.additionalWidgetsComposite);
        return this.additionalWidgetsComposite;
    }

    private void createAdditionalToolbar(Composite parent) {
        this.sourceFolderFilterExtension.contributeTo(this.toolBarManager);
        this.toolBarManager.createControl(parent);
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ClassGraphView.this.additionalWidgetsComposite.layout();
                ClassGraphView.super.refresh();
            }
        });
    }
}

