/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.sourcefolder;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class SourceFolderScanner {
    private static final Comparator<IPath> PATH_COMPARATOR = new Comparator<IPath>(){

        @Override
        public int compare(IPath path1, IPath path2) {
            return path1.toPortableString().compareTo(path2.toPortableString());
        }
    };

    public Set<IPath> scan(IJavaProject ... projects) throws JavaModelException {
        Set<IPath> paths = this.newSet();
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            paths.addAll(this.scanProject(project));
            ++n2;
        }
        return paths;
    }

    private Set<IPath> scanProject(IJavaProject project) throws JavaModelException {
        Set<IPath> paths = this.newSet();
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            if (this.isSourceFolder(packageFragmentRoot)) {
                IPath sourceFolderPath = this.makeRelativeToBasePath(packageFragmentRoot.getPath(), project.getPath());
                paths.add(sourceFolderPath);
            }
            ++n2;
        }
        return paths;
    }

    private boolean isSourceFolder(IPackageFragmentRoot packageFragmentRoot) throws JavaModelException {
        return packageFragmentRoot.getKind() == 1;
    }

    private IPath makeRelativeToBasePath(IPath deepPath, IPath basePath) {
        return deepPath.makeRelativeTo(basePath);
    }

    private <T extends IPath> Set<T> newSet() {
        return new TreeSet<IPath>(PATH_COMPARATOR);
    }
}

