/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.sourcefolder;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.projectusus.jfeet.selection.ElementsFrom;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderFilter;

public class SourceFolderFilterSelectionDialog
extends CheckedTreeSelectionDialog {
    public SourceFolderFilterSelectionDialog(Shell parent, SourceFolderFilter filter) {
        super(parent, (ILabelProvider)new SourceFolderLabelProvider(), (ITreeContentProvider)new SourceFolderContentProvider());
        this.setTitle("Visible source folders");
        this.setMessage("Please select visible source folders:");
        this.setHelpAvailable(false);
        this.setValidator(new AtLeastOneSourceFolderValidator());
        this.setInput(filter.getAllSourceFolders());
        this.setInitialElementSelections(filter.getVisibleSourceFolders());
    }

    List<IPath> getSelectedSourceFolders() {
        return new ElementsFrom((ISelection)new StructuredSelection(super.getResult())).as(IPath.class);
    }

    private static final class AtLeastOneSourceFolderValidator
    implements ISelectionStatusValidator {
        private AtLeastOneSourceFolderValidator() {
        }

        public IStatus validate(Object[] selection) {
            if (selection.length > 0) {
                return this.status(0, "");
            }
            return this.status(4, "Please select at least one source folder.");
        }

        private IStatus status(int status, String message) {
            return new Status(status, "org.projectusus.ui.dependencygraph", message);
        }
    }

    private static final class SourceFolderContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private SourceFolderContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private static final class SourceFolderLabelProvider
    extends LabelProvider {
        private SourceFolderLabelProvider() {
        }

        public Image getImage(Object element) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif");
        }
    }
}

