/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.sourcefolder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.projectusus.core.IUsusModelListener;
import org.projectusus.core.project.FindUsusProjects;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.ui.dependencygraph.common.IRefreshable;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderChangeDetector;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderFilter;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderFilterAction;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderScanner;
import org.projectusus.ui.internal.UsusUIPlugin;

public class SourceFolderFilterExtension {
    private final IRefreshable refreshable;
    private final SourceFolderFilter filter = new SourceFolderFilter();
    private final SourceFolderFilterAction action;
    private final IUsusModelListener ususModelListener = new IUsusModelListener(){

        public void ususModelChanged() {
            SourceFolderFilterExtension.this.recomputeSourceFolders();
        }
    };
    private final IElementChangedListener elementChangedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            if (SourceFolderChangeDetector.detectSourceFolderChange(event.getDelta())) {
                SourceFolderFilterExtension.this.recomputeSourceFolders();
            }
        }
    };

    public SourceFolderFilterExtension(IRefreshable refreshable) {
        this.refreshable = refreshable;
        this.action = new SourceFolderFilterAction(this.filter, refreshable);
    }

    public void initialize() {
        UsusModelProvider.ususModel().addUsusModelListener(this.ususModelListener);
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementChangedListener);
        this.recomputeSourceFolders();
    }

    public ViewerFilter getFilter() {
        return this.filter;
    }

    public void contributeTo(ToolBarManager toolBarManager) {
        ActionContributionItem actionContribution = new ActionContributionItem((IAction)this.action);
        actionContribution.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolBarManager.add((IContributionItem)actionContribution);
    }

    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementChangedListener);
        UsusModelProvider.ususModel().removeUsusModelListener(this.ususModelListener);
    }

    private void recomputeSourceFolders() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        List ususProjects = new FindUsusProjects(allProjects).compute();
        IJavaProject[] ususJavaProjects = this.convertToJavaProjects(ususProjects);
        Set<IPath> allSourceFolders = this.scanForSourceFolders(ususJavaProjects);
        boolean changed = this.filter.updateSourceFolders(new ArrayList<IPath>(allSourceFolders));
        if (changed) {
            this.action.updateState();
            this.refreshable.refresh();
        }
    }

    private Set<IPath> scanForSourceFolders(IJavaProject[] ususJavaProjects) {
        try {
            return new SourceFolderScanner().scan(ususJavaProjects);
        }
        catch (JavaModelException e) {
            UsusUIPlugin.getDefault().log((Exception)((Object)e));
            return Collections.emptySet();
        }
    }

    private IJavaProject[] convertToJavaProjects(List<IProject> ususProjects) {
        LinkedList<IJavaProject> result = new LinkedList<IJavaProject>();
        for (IProject project : ususProjects) {
            if (!this.canScanProject(project)) continue;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            result.add(javaProject);
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    private boolean canScanProject(IProject project) {
        try {
            return project.isOpen() && project.getProject().hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

