/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.sourcefolder;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.projectusus.ui.dependencygraph.DependencyGraphPlugin;
import org.projectusus.ui.dependencygraph.common.IRefreshable;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderFilter;
import org.projectusus.ui.dependencygraph.sourcefolder.SourceFolderFilterSelectionDialog;

public final class SourceFolderFilterAction
extends Action {
    private final SourceFolderFilter filter;
    private final IRefreshable refreshable;

    public SourceFolderFilterAction(SourceFolderFilter filter, IRefreshable refreshable) {
        super("", 2);
        this.filter = filter;
        this.refreshable = refreshable;
        this.updateState();
    }

    public void runWithEvent(Event event) {
        List<IPath> newVisibleSourceFolders;
        Shell shell = event.display.getActiveShell();
        SourceFolderFilterSelectionDialog dialog = this.createSelectionDialog(shell);
        boolean changed = false;
        if (dialog.open() == 0 && this.hasChanged(newVisibleSourceFolders = dialog.getSelectedSourceFolders())) {
            this.filter.setVisibleSourceFolders(newVisibleSourceFolders);
            changed = true;
        }
        this.updateState();
        if (changed) {
            this.refreshable.refresh();
        }
    }

    private boolean hasChanged(List<IPath> newVisibleSourceFolders) {
        return !newVisibleSourceFolders.equals(this.filter.getVisibleSourceFolders());
    }

    private SourceFolderFilterSelectionDialog createSelectionDialog(Shell shell) {
        return new SourceFolderFilterSelectionDialog(shell, this.filter);
    }

    public void updateState() {
        this.setChecked(this.filter.isFiltering());
        if (this.isChecked()) {
            this.setImageDescriptor(DependencyGraphPlugin.plugin().imageForPath("icons/source_folder_filter_active.png"));
            this.setText(String.valueOf(this.filter.getVisibleSourceFolders().size()) + "/" + this.filter.getAllSourceFolders().size() + " source folders");
            this.setToolTipText("Visible source folders: " + StringUtils.join(this.filter.getVisibleSourceFolders(), (String)", "));
        } else {
            this.setImageDescriptor(DependencyGraphPlugin.plugin().imageForPath("icons/source_folder_filter_inactive.png"));
            this.setText("All source folders");
            this.setToolTipText(null);
        }
    }
}

