/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.sourcefolder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.projectusus.ui.dependencygraph.filters.NodeAndEdgeFilter;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;

public class SourceFolderFilter
extends NodeAndEdgeFilter {
    private List<IPath> allSourceFolders = new ArrayList<IPath>();
    private List<IPath> visibleSourceFolders = new ArrayList<IPath>();

    public List<IPath> getAllSourceFolders() {
        return this.allSourceFolders;
    }

    public boolean updateSourceFolders(List<IPath> allSourceFolders) {
        if (this.allSourceFolders.equals(allSourceFolders)) {
            return false;
        }
        this.visibleSourceFolders.retainAll(allSourceFolders);
        this.visibleSourceFolders.addAll(this.addedSourceFolders(allSourceFolders));
        this.allSourceFolders = new ArrayList<IPath>(allSourceFolders);
        return true;
    }

    private List<IPath> addedSourceFolders(List<IPath> newSourceFolders) {
        List<IPath> oldSourceFolders = this.allSourceFolders;
        LinkedList<IPath> result = new LinkedList<IPath>(newSourceFolders);
        result.removeAll(oldSourceFolders);
        return result;
    }

    public List<IPath> getVisibleSourceFolders() {
        return this.visibleSourceFolders;
    }

    public void setVisibleSourceFolders(List<IPath> visibleSourceFolders) {
        this.visibleSourceFolders = visibleSourceFolders;
    }

    @Override
    public String getDescription() {
        return "Show only classes in source folders " + StringUtils.join(this.visibleSourceFolders, (String)", ");
    }

    @Override
    protected boolean select(GraphNode node, Set<GraphNode> others) {
        return !this.isFiltering() || this.isContainedByVisibleSourceFolder(node);
    }

    private boolean isContainedByVisibleSourceFolder(GraphNode node) {
        IJavaElement javaElement = JavaCore.create((IFile)node.getFile());
        IJavaElement packageFragmentRoot = javaElement.getAncestor(3);
        IJavaProject javaProject = packageFragmentRoot.getJavaProject();
        IPath packagePath = packageFragmentRoot.getPath();
        IPath projectPath = javaProject.getPath();
        IPath relativePath = packagePath.makeRelativeTo(projectPath);
        return this.visibleSourceFolders.contains(relativePath);
    }

    public boolean isFiltering() {
        return this.allSourceFolders.size() > this.visibleSourceFolders.size();
    }
}

