/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.sourcefolder;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.projectusus.core.project2.UsusProjectSupport;

public class SourceFolderChangeDetector {
    public static boolean detectSourceFolderChange(IJavaElementDelta delta) {
        return new SourceFolderChangeDetector().analyze(delta);
    }

    public boolean analyze(IJavaElementDelta delta) {
        int elementType = delta.getElement().getElementType();
        if (elementType == 1) {
            return this.checkModel(delta);
        }
        if (elementType == 2) {
            return this.checkProject(delta);
        }
        return elementType == 3;
    }

    private boolean isCoveredProject(IJavaElement javaElement) {
        return UsusProjectSupport.asUsusProject((IProject)((IJavaProject)javaElement).getProject()).isUsusProject();
    }

    private boolean checkModel(IJavaElementDelta delta) {
        return this.checkAll(delta.getChangedChildren());
    }

    private boolean checkProject(IJavaElementDelta delta) {
        if (this.isCoveredProject(delta.getElement())) {
            return this.checkAll(delta.getAddedChildren()) || this.checkAll(delta.getRemovedChildren());
        }
        return false;
    }

    private boolean checkAll(IJavaElementDelta[] deltas) {
        IJavaElementDelta[] iJavaElementDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            if (this.analyze(delta)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

