/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.nodes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.projectusus.core.filerelations.model.PackageRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;

public class PackageRepresenter
extends PlatformObject
implements GraphNode {
    private final Packagename packagename;
    private static PackageRelations relations;

    public static Set<GraphNode> getAllPackages() {
        return PackageRepresenter.transformToRepresenterSet(Packagename.getAll(), new PackageRelations());
    }

    public static Set<GraphNode> transformToRepresenterSet(Set<Packagename> classes, PackageRelations rel) {
        relations = rel;
        Function<Packagename, PackageRepresenter> function = new Function<Packagename, PackageRepresenter>(){

            public PackageRepresenter apply(Packagename descriptor) {
                return new PackageRepresenter(descriptor);
            }
        };
        return new HashSet<GraphNode>(Collections2.transform(classes, (Function)function));
    }

    public PackageRepresenter(Packagename pkg) {
        this.packagename = pkg;
    }

    @Override
    public Set<? extends GraphNode> getChildren() {
        return PackageRepresenter.transformToRepresenterSet(relations.getDirectPackageRelationsFrom(this.packagename), relations);
    }

    @Override
    public Set<? extends GraphNode> getParents() {
        return PackageRepresenter.transformToRepresenterSet(relations.getDirectPackageRelationsTo(this.packagename), relations);
    }

    @Override
    public String getEdgeEndLabel() {
        return "";
    }

    @Override
    public String getEdgeMiddleLabel() {
        return "";
    }

    @Override
    public String getEdgeStartLabel() {
        return "";
    }

    public boolean equals(Object obj) {
        return obj instanceof PackageRepresenter && this.packagename.equals((Object)((PackageRepresenter)obj).packagename);
    }

    public int hashCode() {
        return this.packagename.hashCode();
    }

    @Override
    public int getFilterValue() {
        return 0;
    }

    @Override
    public IFile getFile() {
        return null;
    }

    public Packagename getPackagename() {
        return this.packagename;
    }

    @Override
    public boolean isPackageOneOf(Collection<Packagename> packages) {
        return packages.contains(this.packagename);
    }

    @Override
    public boolean isAtEitherEndOf(Packagename source, Packagename dest) {
        return this.packagename.equals((Object)source) || this.packagename.equals((Object)dest);
    }

    @Override
    public Packagename getRelatedPackage() {
        return this.packagename;
    }

    @Override
    public boolean isVisibleForLimitWithOtherNodes(boolean restricting, Set<GraphNode> others) {
        if (restricting) {
            return relations.getPackageCycles().containsPackage(this.packagename);
        }
        return true;
    }

    @Override
    public boolean isInDifferentPackageThan(GraphNode destination) {
        return !this.getRelatedPackage().equals((Object)destination.getRelatedPackage());
    }

    @Override
    public String getDisplayText() {
        return JavaElementLabels.getTextLabel((Object)this.packagename.getJavaElement(), (long)0x2000000000L);
    }

    @Override
    public String getImageName() {
        return "org.eclipse.jdt.ui.package_obj.gif";
    }

    @Override
    public String getTooltipText() {
        return this.getDisplayText();
    }

    @Override
    public boolean represents(IJavaElement javaElement) {
        IJavaElement pkg = javaElement.getAncestor(4);
        return pkg != null && this.getRelatedPackage().getJavaElement().getElementName().equals(pkg.getElementName());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IJavaElement.class)) {
            return this.getPackagename().getJavaElement();
        }
        return super.getAdapter(adapter);
    }
}

