/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.nodes;

import ch.akuhn.foreach.Collect;
import ch.akuhn.foreach.ForEach;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.projectusus.core.filerelations.model.ClassDescriptor;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;
import org.projectusus.ui.dependencygraph.nodes.PackageRepresenter;

public class ClassRepresenter
extends PlatformObject
implements GraphNode {
    private final ClassDescriptor clazz;

    public static Set<GraphNode> getAllClassRepresenters() {
        return ClassRepresenter.transformToRepresenterSet(ClassDescriptor.getAll());
    }

    public static Set<GraphNode> transformToRepresenterSet(Set<ClassDescriptor> classes) {
        return ClassRepresenter.standardJavaVersion(classes);
    }

    private static Set<GraphNode> foreachVersion(Set<ClassDescriptor> classes) {
        for (Collect each : ForEach.collect(classes)) {
            each.yield = new ClassRepresenter((ClassDescriptor)each.value);
        }
        return new HashSet<GraphNode>((Collection)ForEach.result());
    }

    private static Set<GraphNode> standardJavaVersion(Set<ClassDescriptor> classes) {
        HashSet<GraphNode> result = new HashSet<GraphNode>();
        for (ClassDescriptor classDescriptor : classes) {
            result.add(new ClassRepresenter(classDescriptor));
        }
        return result;
    }

    private static Set<GraphNode> versionWithGoogleCollection(Set<ClassDescriptor> classes) {
        Function<ClassDescriptor, ClassRepresenter> function = new Function<ClassDescriptor, ClassRepresenter>(){

            public ClassRepresenter apply(ClassDescriptor descriptor) {
                return new ClassRepresenter(descriptor);
            }
        };
        return new HashSet<GraphNode>(Collections2.transform(classes, (Function)function));
    }

    public ClassRepresenter(ClassDescriptor clazz) {
        this.clazz = clazz;
    }

    public Set<GraphNode> getChildren() {
        return ClassRepresenter.transformToRepresenterSet(this.clazz.getChildren());
    }

    public Set<GraphNode> getParents() {
        return ClassRepresenter.transformToRepresenterSet(this.clazz.getParents());
    }

    public boolean equals(Object obj) {
        return obj instanceof ClassRepresenter && this.clazz.equals((Object)((ClassRepresenter)obj).clazz);
    }

    @Override
    public int getFilterValue() {
        return this.getChildrenAndParentsInOtherPackages().size();
    }

    private Set<ClassDescriptor> getChildrenAndParentsInOtherPackages() {
        Set result = this.clazz.getChildrenInOtherPackages();
        result.addAll(this.clazz.getParentsInOtherPackages());
        return result;
    }

    @Override
    public boolean isVisibleForLimitWithOtherNodes(boolean restricting, Set<GraphNode> others) {
        if (!restricting) {
            return true;
        }
        if (this.getFilterValue() == 0) {
            return false;
        }
        for (GraphNode graphNode : others) {
            ClassRepresenter otherRepresenter = (ClassRepresenter)graphNode;
            if (!this.hasConnectionTo(otherRepresenter)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConnectionTo(ClassRepresenter otherRepresenter) {
        return this.getChildrenAndParentsInOtherPackages().contains(otherRepresenter.clazz);
    }

    @Override
    public IFile getFile() {
        return this.clazz.getFile();
    }

    @Override
    public String getEdgeEndLabel() {
        return "";
    }

    @Override
    public String getEdgeMiddleLabel() {
        return "";
    }

    @Override
    public String getEdgeStartLabel() {
        return "";
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public boolean isPackageOneOf(Collection<Packagename> packages) {
        return packages.contains(this.getPackagename());
    }

    public Packagename getPackagename() {
        return this.clazz.getPackagename();
    }

    @Override
    public boolean isAtEitherEndOf(Packagename source, Packagename dest) {
        return this.connects(source, this.clazz.getChildren(), dest) || this.connects(dest, this.clazz.getParents(), source);
    }

    private boolean connects(Packagename classPackage, Set<ClassDescriptor> relateds, Packagename relatedPackage) {
        if (this.clazz.getPackagename().equals((Object)classPackage)) {
            for (ClassDescriptor related : relateds) {
                if (!related.getPackagename().equals((Object)relatedPackage)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Packagename getRelatedPackage() {
        return this.clazz.getPackagename();
    }

    @Override
    public boolean isInDifferentPackageThan(GraphNode destination) {
        return !this.getRelatedPackage().equals((Object)destination.getRelatedPackage());
    }

    @Override
    public String getDisplayText() {
        return this.clazz.getClassname().toString();
    }

    @Override
    public String getImageName() {
        return "org.eclipse.jdt.ui.class_obj.gif";
    }

    @Override
    public String getTooltipText() {
        return new PackageRepresenter(this.getRelatedPackage()).getTooltipText();
    }

    @Override
    public boolean represents(IJavaElement javaElement) {
        return javaElement.getResource().equals((Object)this.getFile());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IJavaElement.class)) {
            return JavaCore.create((IFile)this.getFile());
        }
        return super.getAdapter(adapter);
    }
}

