/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.filters;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.ui.dependencygraph.filters.IRestrictNodesFilterProvider;
import org.projectusus.ui.dependencygraph.filters.NodeAndEdgeFilter;
import org.projectusus.ui.dependencygraph.nodes.ClassRepresenter;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;
import org.projectusus.ui.dependencygraph.nodes.PackageRepresenter;

public class PackagenameNodeFilter
extends NodeAndEdgeFilter {
    private static final Joiner commaJoiner = Joiner.on((String)", ");
    private static final Function<EntityConnectionData, String> toArrowSeparatedStrings = new Function<EntityConnectionData, String>(){

        public String apply(EntityConnectionData edge) {
            return ((PackageRepresenter)edge.source).getPackagename() + " \u2192 " + ((PackageRepresenter)edge.dest).getPackagename();
        }
    };
    private Collection<Packagename> packages;
    private Collection<EntityConnectionData> edges;
    private IRestrictNodesFilterProvider filterLimitProvider;

    public void setPackages(Collection<Packagename> packages) {
        this.packages = packages;
    }

    public void setEdges(Collection<EntityConnectionData> collectedEdges) {
        this.edges = collectedEdges;
    }

    public void resetPackages() {
        this.setPackages(null);
        this.setEdges(null);
    }

    public static PackagenameNodeFilter from(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return PackagenameNodeFilter.from((IStructuredSelection)selection);
        }
        return new PackagenameNodeFilter();
    }

    public static PackagenameNodeFilter from(IStructuredSelection selection) {
        PackagenameNodeFilter filter = new PackagenameNodeFilter();
        filter.setPackages(PackagenameNodeFilter.collectPackages(selection));
        filter.setEdges(PackagenameNodeFilter.collectEdges(selection));
        return filter;
    }

    private static Collection<EntityConnectionData> collectEdges(IStructuredSelection selection) {
        LinkedList<EntityConnectionData> edges = new LinkedList<EntityConnectionData>();
        for (Object item : selection.toList()) {
            PackagenameNodeFilter.addEdge(edges, item);
        }
        return edges;
    }

    private static void addEdge(Collection<EntityConnectionData> edges, Object item) {
        if (item instanceof EntityConnectionData) {
            edges.add((EntityConnectionData)item);
        }
    }

    private static Collection<Packagename> collectPackages(IStructuredSelection selection) {
        LinkedList<Packagename> packages = new LinkedList<Packagename>();
        for (Object item : selection.toList()) {
            PackagenameNodeFilter.add(packages, item);
        }
        return packages;
    }

    private static void add(Collection<Packagename> packages, Object item) {
        if (item instanceof PackageRepresenter) {
            PackagenameNodeFilter.add(packages, (PackageRepresenter)item);
        } else if (item instanceof IPackageFragment) {
            PackagenameNodeFilter.add(packages, (IPackageFragment)item);
        }
    }

    private static void add(Collection<Packagename> packages, IPackageFragment fragment) {
        packages.add(Packagename.of((String)fragment.getElementName(), (IJavaElement)fragment));
    }

    private static void add(Collection<Packagename> packages, PackageRepresenter representer) {
        packages.add(representer.getPackagename());
    }

    public boolean isEmpty() {
        return this.packagesAreEmpty() && this.edgesAreEmpty();
    }

    public boolean packagesAreEmpty() {
        return this.nullOrEmpty(this.packages);
    }

    public boolean edgesAreEmpty() {
        return this.nullOrEmpty(this.edges);
    }

    public boolean nullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @Override
    protected boolean select(GraphNode node, Set<GraphNode> others) {
        return this.isDirectlySelected(node) && this.checkRelations(node, others);
    }

    private boolean isDirectlySelected(GraphNode node) {
        return this.selectedByPackages(node) || this.selectedByEdges(node);
    }

    private boolean checkRelations(GraphNode node, Set<GraphNode> others) {
        if (node instanceof ClassRepresenter) {
            if (!this.filterLimitProvider.isRestricting()) {
                return true;
            }
            ClassRepresenter representer = (ClassRepresenter)node;
            for (GraphNode graphNode : others) {
                ClassRepresenter otherRepresenter = (ClassRepresenter)graphNode;
                if (!representer.hasConnectionTo(otherRepresenter) || !this.isDirectlySelected(graphNode)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean selectedByEdges(GraphNode node) {
        return this.edges == null || this.isPartOfEdges(node);
    }

    private boolean selectedByPackages(GraphNode node) {
        return this.packages == null || node.isPackageOneOf(this.packages);
    }

    private boolean isPartOfEdges(GraphNode node) {
        for (EntityConnectionData edge : this.edges) {
            Packagename target;
            Packagename source = ((PackageRepresenter)edge.source).getPackagename();
            if (!node.isAtEitherEndOf(source, target = ((PackageRepresenter)edge.dest).getPackagename())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        LinkedList<String> parts = new LinkedList<String>();
        this.describeEdgesTo(parts);
        this.describePackagesTo(parts);
        return Joiner.on((char)'\n').join(parts);
    }

    private void describeEdgesTo(Collection<String> parts) {
        if (this.edgesAreEmpty()) {
            return;
        }
        parts.add("Only items that cause one of the following package references: " + commaJoiner.join((Iterable)Collections2.transform(this.edges, toArrowSeparatedStrings)));
    }

    private void describePackagesTo(Collection<String> parts) {
        if (this.packagesAreEmpty()) {
            return;
        }
        parts.add("Only items in one of the following packages: " + commaJoiner.join(this.packages));
    }

    @Override
    public void setFilterLimitProvider(IRestrictNodesFilterProvider filterLimitProvider) {
        this.filterLimitProvider = filterLimitProvider;
    }
}

