/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.filters;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.projectusus.ui.dependencygraph.filters.NodeAndEdgeFilter;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;

public class DirectNeighboursFilter
extends NodeAndEdgeFilter {
    private Set<GraphNode> directNeighbours = new HashSet<GraphNode>();
    private List<String> selectedNodeNames = new ArrayList<String>();

    public DirectNeighboursFilter(Set<GraphNode> selectedNodes) {
        this.directNeighbours = new HashSet<GraphNode>();
        for (GraphNode selectedNode : selectedNodes) {
            this.directNeighbours.add(selectedNode);
            this.directNeighbours.addAll(selectedNode.getChildren());
            this.directNeighbours.addAll(selectedNode.getParents());
            this.selectedNodeNames.add(selectedNode.getDisplayText());
        }
    }

    @Override
    public String getDescription() {
        return "Direct neighbours of " + Joiner.on((String)", ").join(this.selectedNodeNames);
    }

    @Override
    protected boolean select(GraphNode node, Set<GraphNode> others) {
        return this.directNeighbours.contains(node);
    }
}

