/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class WorkbenchContext {
    private final IContextService service;
    private final String contextId;
    private IContextActivation activation;

    public WorkbenchContext(String contextId) {
        this((IContextService)PlatformUI.getWorkbench().getService(IContextService.class), contextId);
    }

    public WorkbenchContext(IContextService service, String contextId) {
        this.service = service;
        this.contextId = contextId;
    }

    public void activate() {
        if (this.isDeactivated()) {
            this.activation = this.service.activateContext(this.contextId);
        }
    }

    public void deactivate() {
        if (this.isActivated()) {
            this.service.deactivateContext(this.activation);
            this.activation = null;
        }
    }

    public boolean isActivated() {
        return !this.isDeactivated();
    }

    public boolean isDeactivated() {
        return this.activation == null;
    }
}

