/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.projectusus.ui.dependencygraph.common.GraphLayout;

public class GraphLayoutComboViewer {
    private static final String LAYOUT_LABEL = "Layout:";

    public GraphLayoutComboViewer(Composite parent, ISelectionChangedListener listener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.createLabel(parent, LAYOUT_LABEL);
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        comboViewer.setInput((Object)this.allLayoutsSortedByTitle());
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)GraphLayout.getDefault()));
        comboViewer.addSelectionChangedListener(listener);
    }

    private GraphLayout[] allLayoutsSortedByTitle() {
        GraphLayout[] layouts = GraphLayout.values();
        Arrays.sort(layouts, this.byTitle());
        return layouts;
    }

    private Comparator<GraphLayout> byTitle() {
        return new Comparator<GraphLayout>(){

            @Override
            public int compare(GraphLayout first, GraphLayout second) {
                return first.title().compareTo(second.title());
            }
        };
    }

    private Label createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        return label;
    }
}

