/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;

public enum GraphLayout {
    GRID("Grid"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new GridLayoutAlgorithm(1);
        }
    }
    ,
    HORIZONTAL("Linear (horizontal)"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new HorizontalLayoutAlgorithm(1);
        }
    }
    ,
    HORIZONTAL_TREE("Tree (horizontal)"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new HorizontalTreeLayoutAlgorithm(1);
        }
    }
    ,
    RADIAL("Radial"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new RadialLayoutAlgorithm(1);
        }
    }
    ,
    SPRING("Spring"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new SpringLayoutAlgorithm(1);
        }
    }
    ,
    TREE("Tree (vertical)"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new TreeLayoutAlgorithm(1);
        }
    }
    ,
    VERTICAL("Linear (vertical)"){

        @Override
        public LayoutAlgorithm createAlgorithm() {
            return new VerticalLayoutAlgorithm(1);
        }
    };

    private static final int DEFAULT_STYLE = 1;
    private final String title;

    private GraphLayout(String title) {
        this.title = title;
    }

    public String title() {
        return this.title;
    }

    public String toString() {
        return this.title();
    }

    public abstract LayoutAlgorithm createAlgorithm();

    public static GraphLayout getDefault() {
        return SPRING;
    }

    /* synthetic */ GraphLayout(String string, int n, String string2, GraphLayout graphLayout) {
        this(string2);
    }
}

