/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.ui.dependencygraph.common.GraphLayout;
import org.projectusus.ui.dependencygraph.nodes.IEdgeColorProvider;
import org.projectusus.ui.dependencygraph.nodes.NodeContentProvider;
import org.projectusus.ui.dependencygraph.nodes.NodeLabelProvider;
import org.projectusus.ui.dependencygraph.nodes.PackageRepresenter;
import org.projectusus.ui.util.EditorOpener;

public class DependencyGraphViewer
extends GraphViewer {
    private final List<ISelectionChangedListener> duplicatedSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final NodeLabelProvider labelProvider;

    public DependencyGraphViewer(Composite composite, IEdgeColorProvider edgeColorProvider) {
        super(composite, 0);
        this.labelProvider = new NodeLabelProvider(edgeColorProvider);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setConnectionStyle(2);
        this.setContentProvider((IContentProvider)new NodeContentProvider());
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = DependencyGraphViewer.this.getSelection();
                Object selected = ((IStructuredSelection)selection).getFirstElement();
                if (selected instanceof org.projectusus.ui.dependencygraph.nodes.GraphNode) {
                    org.projectusus.ui.dependencygraph.nodes.GraphNode graphNode = (org.projectusus.ui.dependencygraph.nodes.GraphNode)selected;
                    EditorOpener opener = new EditorOpener();
                    opener.openEditor(graphNode.getFile());
                }
            }
        });
        this.setLayout(GraphLayout.getDefault());
    }

    public void setLayout(GraphLayout layout) {
        this.setLayoutAlgorithm(layout.createAlgorithm(), false);
    }

    public Set<Packagename> getVisibleNodes() {
        this.refresh();
        Object[] allVisibleNodes = this.getFilteredChildren(this.getInput());
        HashSet<Packagename> packageNames = new HashSet<Packagename>();
        Object[] objectArray = allVisibleNodes;
        int n = allVisibleNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            if (node instanceof PackageRepresenter) {
                packageNames.add(((PackageRepresenter)node).getPackagename());
            }
            ++n2;
        }
        return packageNames;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        super.addSelectionChangedListener(listener);
        this.duplicatedSelectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        super.removeSelectionChangedListener(listener);
        this.duplicatedSelectionChangedListeners.remove(listener);
    }

    void fireSelectionChanged() {
        ISelection structuredSelection = this.getSelection();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, structuredSelection);
        for (ISelectionChangedListener listener : this.duplicatedSelectionChangedListeners) {
            listener.selectionChanged(event);
        }
    }

    public Set<org.projectusus.ui.dependencygraph.nodes.GraphNode> getSelectedNodes() {
        return this.convert(this.getGraphControl().getSelection());
    }

    public Set<org.projectusus.ui.dependencygraph.nodes.GraphNode> getAllNodes() {
        return this.convert(this.getGraphControl().getNodes());
    }

    private Set<org.projectusus.ui.dependencygraph.nodes.GraphNode> convert(List<GraphItem> selection) {
        HashSet<org.projectusus.ui.dependencygraph.nodes.GraphNode> result = new HashSet<org.projectusus.ui.dependencygraph.nodes.GraphNode>();
        for (GraphItem graphItem : selection) {
            if (!(graphItem instanceof GraphNode)) continue;
            result.add((org.projectusus.ui.dependencygraph.nodes.GraphNode)graphItem.getData());
        }
        return result;
    }

    public Image takeScreenshot() {
        Graph graph = (Graph)this.getControl();
        IFigure contents = graph.getContents();
        Image image = new Image(null, contents.getSize().width, contents.getSize().height);
        GC gc = new GC((Drawable)image);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        Rectangle bounds = contents.getBounds();
        Point viewLocation = graph.getViewport().getViewLocation();
        swtGraphics.translate(-1 * bounds.x + viewLocation.x, -1 * bounds.y + viewLocation.y);
        graph.getViewport().paint((Graphics)swtGraphics);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        return image;
    }

    public void addFilterIfNotAlreadyPresent(ViewerFilter filter) {
        this.replaceFilter(filter, filter);
    }

    public void replaceFilter(ViewerFilter existingFilter, ViewerFilter newFilter) {
        List<ViewerFilter> filters = this.collectFiltersExcept(existingFilter);
        filters.add(newFilter);
        this.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    private List<ViewerFilter> collectFiltersExcept(ViewerFilter existingFilter) {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewerFilter = viewerFilterArray[n2];
            if (viewerFilter != existingFilter) {
                filters.add(viewerFilter);
            }
            ++n2;
        }
        return filters;
    }

    void selectNodes(List<org.projectusus.ui.dependencygraph.nodes.GraphNode> nodesToSelect) {
        this.setSelection((ISelection)new StructuredSelection(nodesToSelect));
    }

    public void setHighlightStrongConnections(boolean highlightStrongConnections) {
        this.labelProvider.setHighlightStrongConnections(highlightStrongConnections);
    }
}

