/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.ConvertingSelectionProvider;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.projectusus.core.IUsusModelListener;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.core.statistics.UsusModelProvider;
import org.projectusus.jfeet.selection.ElementFrom;
import org.projectusus.ui.dependencygraph.common.ChangeZoom;
import org.projectusus.ui.dependencygraph.common.DependencyGraphModel;
import org.projectusus.ui.dependencygraph.common.DependencyGraphSelectionListener;
import org.projectusus.ui.dependencygraph.common.DependencyGraphViewer;
import org.projectusus.ui.dependencygraph.common.GraphLayout;
import org.projectusus.ui.dependencygraph.common.GraphLayoutComboViewer;
import org.projectusus.ui.dependencygraph.common.IRefreshable;
import org.projectusus.ui.dependencygraph.common.SelectionSynchronizationListener;
import org.projectusus.ui.dependencygraph.common.WorkbenchContext;
import org.projectusus.ui.dependencygraph.filters.DirectNeighboursFilter;
import org.projectusus.ui.dependencygraph.filters.HideNodesFilter;
import org.projectusus.ui.dependencygraph.filters.IRestrictNodesFilterProvider;
import org.projectusus.ui.dependencygraph.filters.LimitNodeFilter;
import org.projectusus.ui.dependencygraph.filters.NodeAndEdgeFilter;
import org.projectusus.ui.dependencygraph.filters.PackagenameNodeFilter;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;
import org.projectusus.ui.dependencygraph.nodes.IEdgeColorProvider;

public abstract class DependencyGraphView
extends ViewPart
implements IRestrictNodesFilterProvider,
IShowInTarget,
IZoomableWorkbenchPart,
IMenuListener,
IRefreshable {
    private final DependencyGraphModel model;
    private DependencyGraphViewer graphViewer;
    private RefactorActionGroup refactorAction;
    private IUsusModelListener listener;
    private NodeAndEdgeFilter customFilter;
    private final WorkbenchContext customFilterContext;
    private final HideNodesFilter hideNodesFilter = new HideNodesFilter();
    private boolean restricting = false;
    private DependencyGraphSelectionListener selectionListener;
    private final IPartListener2 selectionSynchronizationListener = new SelectionSynchronizationListener(this);
    private final IEdgeColorProvider edgeColorProvider;

    public DependencyGraphView(String viewId, DependencyGraphModel model, IEdgeColorProvider edgeColorProvider) {
        this.model = model;
        this.edgeColorProvider = edgeColorProvider;
        this.customFilterContext = new WorkbenchContext(String.valueOf(viewId) + ".context.customFilter");
        this.initUsusModelListener();
    }

    public void createPartControl(Composite parent) {
        Composite composite = DependencyGraphView.createComposite(parent);
        this.createFilterArea(composite);
        this.createGraphViewer(new DependencyGraphViewer(DependencyGraphView.createGraphArea(composite), this.edgeColorProvider));
        IViewSite site = this.getViewSite();
        site.setSelectionProvider((ISelectionProvider)this.graphViewer);
        this.contributeTo(site.getActionBars());
        this.refresh();
        this.extendSelectionBehavior();
        this.registerContextMenu(site);
        this.refactorAction = new RefactorActionGroup((IWorkbenchSite)this.getSite(), (ISelectionProvider)new ConvertingSelectionProvider(site.getSelectionProvider()));
    }

    private void registerContextMenu(IViewSite site) {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("nodeActions"));
        this.graphViewer.getGraphControl().setMenu(menuManager.createContextMenu(this.graphViewer.getControl()));
        site.registerContextMenu(menuManager, (ISelectionProvider)this.graphViewer);
        this.createRefactoringMenu(menuManager);
    }

    private void createRefactoringMenu(MenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("group.reorganize"));
        menuManager.addMenuListener((IMenuListener)this);
    }

    private static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void contributeTo(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        Separator separator = new Separator("zoom");
        separator.setVisible(false);
        toolBar.add((IContributionItem)separator);
        toolBar.add((IAction)new ChangeZoom(this));
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (manager.find("org.eclipse.jdt.ui.refactoring.menu") == null) {
            this.refactorAction.fillContextMenu(manager);
        }
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.graphViewer;
    }

    private Composite createFilterArea(Composite composite) {
        Composite filterArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 0;
        layout.marginTop = 5;
        filterArea.setLayout((Layout)layout);
        Control additionalWidgets = this.createAdditionalWidgets(filterArea);
        this.createLayoutComboViewer(filterArea);
        additionalWidgets.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        filterArea.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return filterArea;
    }

    private void createLayoutComboViewer(Composite filterArea) {
        new GraphLayoutComboViewer(filterArea, new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphLayout newLayout = (GraphLayout)((Object)new ElementFrom(event.getSelection()).as(GraphLayout.class));
                        DependencyGraphView.this.switchLayout(newLayout);
                    }
                });
            }
        });
    }

    protected Control createAdditionalWidgets(Composite filterArea) {
        return this.createRestrictingCheckBox(filterArea);
    }

    protected final Button createRestrictingCheckBox(Composite parent) {
        final Button checkbox = new Button(parent, 32);
        checkbox.setText(this.getRestrictingCheckboxLabelName());
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DependencyGraphView.this.setRestricting(checkbox.getSelection());
                        DependencyGraphView.this.refresh();
                    }
                });
            }
        });
        this.setRestricting(false);
        return checkbox;
    }

    private static Composite createGraphArea(Composite composite) {
        Composite graphArea = new Composite(composite, 2048);
        graphArea.setLayoutData((Object)new GridData(4, 4, true, true));
        graphArea.setLayout((Layout)new FillLayout());
        return graphArea;
    }

    private void createGraphViewer(DependencyGraphViewer dependencyGraphViewer) {
        this.graphViewer = dependencyGraphViewer;
        ArrayList<? extends ViewerFilter> filters = new ArrayList<ViewerFilter>();
        filters.add(new LimitNodeFilter(this));
        filters.add(this.hideNodesFilter);
        filters.addAll(this.createAdditionalFilters());
        this.graphViewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    protected Collection<? extends ViewerFilter> createAdditionalFilters() {
        return Collections.emptyList();
    }

    public synchronized void replaceCustomFilter(NodeAndEdgeFilter newCustomFilter) {
        newCustomFilter.setFilterLimitProvider(this);
        this.graphViewer.replaceFilter(this.customFilter, newCustomFilter);
        this.customFilter = newCustomFilter;
        this.setContentDescription(newCustomFilter.getDescription());
        this.customFilterContext.activate();
        this.drawGraphUnconditionally();
    }

    public synchronized void clearCustomFilter() {
        if (this.customFilter != null) {
            this.graphViewer.removeFilter(this.customFilter);
            this.customFilter = null;
            this.clearContentDescription();
        }
        this.customFilterContext.deactivate();
    }

    private void clearContentDescription() {
        this.setContentDescription("");
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependencyGraphView.this.drawGraphConditionally();
                DependencyGraphView.this.applyLayout();
            }
        });
    }

    public void drawGraphConditionally() {
        if (this.model.isChanged()) {
            this.drawGraphUnconditionally();
        } else {
            this.updateEdgeColorProvider();
            this.graphViewer.refresh();
        }
        this.graphViewer.fireSelectionChanged();
    }

    private void drawGraphUnconditionally() {
        this.graphViewer.setInput(this.model.getGraphNodes());
        this.updateEdgeColorProvider();
        this.graphViewer.refresh();
        this.model.resetChanged();
    }

    private void updateEdgeColorProvider() {
        Set<Packagename> visibleNodes = this.graphViewer.getVisibleNodes();
        this.edgeColorProvider.recalculateColors(visibleNodes);
    }

    public void setFocus() {
        this.graphViewer.getControl().setFocus();
    }

    public void dispose() {
        UsusModelProvider.ususModel().removeUsusModelListener(this.listener);
        this.graphViewer.getGraphControl().removeSelectionListener((SelectionListener)this.selectionListener);
        this.registerEditorSynchronizationListener(false);
        if (this.refactorAction != null) {
            this.refactorAction.dispose();
        }
        super.dispose();
    }

    public void registerEditorSynchronizationListener(boolean register) {
        IWorkbenchPage page = this.getSite().getPage();
        if (register) {
            page.addPartListener(this.selectionSynchronizationListener);
            this.selectNodeFromActiveEditor(page.getActiveEditor());
        } else {
            page.removePartListener(this.selectionSynchronizationListener);
        }
    }

    private void initUsusModelListener() {
        this.listener = new IUsusModelListener(){

            public void ususModelChanged() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DependencyGraphView.this.model.invalidate();
                        DependencyGraphView.this.drawGraphConditionally();
                    }
                });
            }
        };
        UsusModelProvider.ususModel().addUsusModelListener(this.listener);
    }

    private void extendSelectionBehavior() {
        this.selectionListener = new DependencyGraphSelectionListener(this.graphViewer);
        this.graphViewer.getGraphControl().addSelectionListener((SelectionListener)this.selectionListener);
    }

    public boolean show(ShowInContext context) {
        PackagenameNodeFilter filter = PackagenameNodeFilter.from(context.getSelection());
        if (filter.isEmpty()) {
            return false;
        }
        this.replaceCustomFilter(filter);
        return true;
    }

    public void hideSelectedNodes() {
        Set<GraphNode> selectedNodes = this.graphViewer.getSelectedNodes();
        if (!selectedNodes.isEmpty()) {
            this.hideNodesFilter.addNodesToHide(selectedNodes);
            this.drawGraphConditionally();
        }
        this.customFilterContext.activate();
    }

    public void selectAllNodesInSamePackage(GraphNode selectedNode) {
        Set<GraphNode> allNodes = this.graphViewer.getAllNodes();
        LinkedList<GraphNode> nodesInSamePackage = new LinkedList<GraphNode>();
        for (GraphNode node : allNodes) {
            if (node.isInDifferentPackageThan(selectedNode)) continue;
            nodesInSamePackage.add(node);
        }
        this.graphViewer.selectNodes(nodesInSamePackage);
    }

    public void showAllDirectNeighbours() {
        this.replaceCustomFilter(new DirectNeighboursFilter(this.graphViewer.getSelectedNodes()));
        this.resetHiddenNodes();
    }

    private void switchLayout(GraphLayout newLayout) {
        this.graphViewer.setLayout(newLayout);
        this.applyLayout();
    }

    public void applyLayout() {
        this.graphViewer.applyLayout();
    }

    public Set<GraphNode> getAllNodesToHide(Set<GraphNode> directNeighbours) {
        HashSet<GraphNode> hideNodes = new HashSet<GraphNode>(this.model.getGraphNodes());
        hideNodes.removeAll(directNeighbours);
        return hideNodes;
    }

    void selectNodeFromActiveEditor(IEditorPart editorPart) {
        IJavaElement javaElement = JavaUI.getEditorInputJavaElement((IEditorInput)editorPart.getEditorInput());
        ArrayList<GraphNode> nodesToSelect = new ArrayList<GraphNode>();
        for (GraphNode node : this.graphViewer.getAllNodes()) {
            if (!node.represents(javaElement)) continue;
            nodesToSelect.add(node);
        }
        this.graphViewer.selectNodes(nodesToSelect);
    }

    public void resetHiddenNodes() {
        this.hideNodesFilter.reset();
        this.drawGraphConditionally();
    }

    public Image takeScreenshot() {
        return this.graphViewer.takeScreenshot();
    }

    public abstract String getFilenameForScreenshot();

    @Override
    public boolean isRestricting() {
        return this.restricting;
    }

    private void setRestricting(boolean restricting) {
        this.restricting = restricting;
    }

    protected abstract String getRestrictingCheckboxLabelName();
}

