/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.projectusus.ui.dependencygraph.common.DependencyGraphViewer;

class DependencyGraphSelectionListener
implements SelectionListener {
    private final DependencyGraphViewer graphViewer;

    public DependencyGraphSelectionListener(DependencyGraphViewer graphViewer) {
        this.graphViewer = graphViewer;
    }

    public void widgetSelected(SelectionEvent event) {
        this.handleOpposingEdge(event);
    }

    private void handleOpposingEdge(SelectionEvent event) {
        if (event.item instanceof GraphConnection) {
            GraphConnection selectedConn = (GraphConnection)event.item;
            Graph graph = (Graph)event.getSource();
            List selection = graph.getSelection();
            boolean adding = selection.contains(selectedConn);
            for (GraphConnection currentConn : graph.getConnections()) {
                if (!this.areOpposing(selectedConn, currentConn)) continue;
                if (adding && !selection.contains(currentConn)) {
                    selection.add(currentConn);
                    this.updateSelectionAndFireEvent(graph, selection);
                    continue;
                }
                if (adding) continue;
                selection.remove(currentConn);
                currentConn.unhighlight();
                this.updateSelectionAndFireEvent(graph, selection);
            }
        }
    }

    private void updateSelectionAndFireEvent(Graph graph, List<GraphItem> selection) {
        graph.setSelection(selection.toArray(new GraphItem[0]));
        this.graphViewer.fireSelectionChanged();
    }

    private boolean areOpposing(GraphConnection conn1, GraphConnection conn2) {
        return conn1.getSource().equals(conn2.getDestination()) && conn1.getDestination().equals(conn2.getSource());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

