/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import java.util.Set;
import org.projectusus.ui.dependencygraph.nodes.GraphNode;

public abstract class DependencyGraphModel {
    private Set<? extends GraphNode> nodes;
    private boolean changed = false;

    public boolean isChanged() {
        return this.nodes == null || this.changed;
    }

    public void resetChanged() {
        this.changed = false;
    }

    public Set<? extends GraphNode> getGraphNodes() {
        if (this.nodes == null) {
            this.nodes = this.getRefreshedNodes();
        }
        return this.nodes;
    }

    protected abstract Set<? extends GraphNode> getRefreshedNodes();

    public void invalidate() {
        Set<? extends GraphNode> freshNodes = this.getRefreshedNodes();
        if (this.nodes != null && !freshNodes.equals(this.nodes)) {
            this.nodes = freshNodes;
            this.changed = true;
        }
    }
}

