/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.common;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.projectusus.ui.dependencygraph.DependencyGraphPlugin;

public class ChangeZoom
extends Action
implements IMenuCreator {
    private static final String LABEL = "Zoom";
    private static final String ICON_PATH = "icons/zoom.gif";
    private final IZoomableWorkbenchPart view;
    private Menu menu;

    public ChangeZoom(IZoomableWorkbenchPart view) {
        super(LABEL, 4);
        this.view = view;
        this.setImageDescriptor(DependencyGraphPlugin.plugin().imageForPath(ICON_PATH));
        this.setMenuCreator(this);
    }

    public void run() {
        this.resetZoom();
    }

    protected void resetZoom() {
        this.view.getZoomableViewer().zoomTo(0, 0, 0, 0);
    }

    public Menu getMenu(Menu parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            this.fill();
        }
        return this.menu;
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            this.fill();
        }
        return this.menu;
    }

    private void fill() {
        new ZoomContributionViewItem(this.view).fill(this.menu, 0);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }
}

