/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.ui.dependencygraph.colorProvider;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.projectusus.core.filerelations.model.PackageRelations;
import org.projectusus.core.filerelations.model.Packagename;
import org.projectusus.ui.colors.UsusColors;
import org.projectusus.ui.dependencygraph.nodes.IEdgeColorProvider;
import org.projectusus.ui.dependencygraph.nodes.PackageRepresenter;

public class PackageEdgeColorProvider
implements IEdgeColorProvider {
    private Supplier<PackageRelations> packageRelationsSupplier;
    private Predicate<Packagename> isVisible = Predicates.alwaysTrue();

    public PackageEdgeColorProvider() {
        this.calculatePackageRelations();
    }

    @Override
    public Color getEdgeColor(Object src, Object dest, boolean highlightStrongConnections) {
        if (highlightStrongConnections) {
            float saturation = this.computeSaturation(src, dest);
            return UsusColors.getSharedColors().adjustSaturation("DARK_RED", saturation);
        }
        return UsusColors.getSharedColors().getColor("DARK_RED");
    }

    private float computeSaturation(Object src, Object dest) {
        PackageRelations packageRelations = (PackageRelations)this.packageRelationsSupplier.get();
        int crossLinkCount = this.getCrossLinkCount((PackageRepresenter)src, (PackageRepresenter)dest, packageRelations);
        float maxCrossLinkCount = packageRelations.getMaxCrossLinkCount();
        float saturation = (float)crossLinkCount / maxCrossLinkCount;
        return saturation;
    }

    private int getCrossLinkCount(PackageRepresenter src, PackageRepresenter target, PackageRelations packageRelations) {
        return packageRelations.getCrossLinkCount(src.getPackagename(), target.getPackagename());
    }

    @Override
    public void recalculateColors(final Set<Packagename> visiblePackages) {
        this.isVisible = new Predicate<Packagename>(){

            public boolean apply(Packagename packagename) {
                return visiblePackages.contains(packagename);
            }
        };
        this.calculatePackageRelations();
    }

    public void calculatePackageRelations() {
        this.packageRelationsSupplier = Suppliers.memoize((Supplier)new Supplier<PackageRelations>(){

            public PackageRelations get() {
                return new PackageRelations(PackageEdgeColorProvider.this.isVisible);
            }
        });
    }
}

