/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.jfeet.selection;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.projectusus.jfeet.selection.ElementsFrom;

public class ElementsFromTest {
    @Test
    public void singleSelectionYieldsElement() {
        StructuredSelection selection = new StructuredSelection(Arrays.asList("x"));
        List<String> result = new ElementsFrom((ISelection)selection).as(String.class);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result, (Matcher)JUnitMatchers.hasItem((Object)"x"));
    }

    @Test
    public void queryWithWrongTypeYieldsEmptyList() {
        StructuredSelection selection = new StructuredSelection((Object)"x");
        List empty = Collections.emptyList();
        Assert.assertThat(new ElementsFrom((ISelection)selection).as(Integer.class), (Matcher)CoreMatchers.is(empty));
    }

    @Test
    public void multiSelectionYieldsAllElements() {
        StructuredSelection selection = new StructuredSelection(Arrays.asList("x", "y", "z"));
        List<String> result = new ElementsFrom((ISelection)selection).as(String.class);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(result, (Matcher)JUnitMatchers.hasItem((Object)"x"));
        Assert.assertThat(result, (Matcher)JUnitMatchers.hasItem((Object)"y"));
        Assert.assertThat(result, (Matcher)JUnitMatchers.hasItem((Object)"z"));
    }

    @Test
    public void multiSelectionYieldsOnlyElementsOfCorrectType() {
        List<Object> elements = Arrays.asList("x", new Object());
        StructuredSelection selection = new StructuredSelection(elements);
        List<String> result = new ElementsFrom((ISelection)selection).as(String.class);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result, (Matcher)JUnitMatchers.hasItem((Object)"x"));
    }

    @Test
    public void adaptableSelectionYieldsElement() {
        final String element = "x";
        IAdaptable adapted = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                return adapter == String.class ? element : null;
            }
        };
        StructuredSelection selection = new StructuredSelection((Object)adapted);
        List<String> result = new ElementsFrom((ISelection)selection).as(String.class);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result, (Matcher)JUnitMatchers.hasItem((Object)"x"));
        List empty = Collections.emptyList();
        Assert.assertThat(new ElementsFrom((ISelection)selection).as(Integer.class), (Matcher)CoreMatchers.is(empty));
    }
}

