/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.jfeet.selection;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.projectusus.jfeet.selection.ElementFrom;

public class ElementFromTest {
    @Test(expected=IllegalArgumentException.class)
    public void typeMustBeSpecified() {
        new ElementFrom(null).as(null);
    }

    @Test
    public void nullSelectionYieldsNull() {
        Assert.assertThat((Object)new ElementFrom(null).as(String.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)new ElementFrom(null).asObject(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void nonStructuredSelectionYieldsNull() {
        ISelection nonStructuredSelection = new ISelection(){

            public boolean isEmpty() {
                return false;
            }
        };
        ElementFrom operation = new ElementFrom(nonStructuredSelection);
        Assert.assertThat((Object)operation.as(String.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)operation.asObject(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void emptySelectionYieldsNull() {
        Assert.assertThat((Object)new ElementFrom((ISelection)StructuredSelection.EMPTY).as(String.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)new ElementFrom((ISelection)StructuredSelection.EMPTY).asObject(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void singleSelectionYieldsElement() {
        String element = "x";
        StructuredSelection selection = new StructuredSelection((Object)element);
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).as(String.class), (Matcher)CoreMatchers.is((Object)element));
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).asObject(), (Matcher)CoreMatchers.is((Object)element));
    }

    @Test
    public void queryWithWrongTypeYieldsNull() {
        StructuredSelection selection = new StructuredSelection((Object)"x");
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).as(Integer.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void multiSelectionYieldsFirstElement() {
        String element = "x";
        List<Object> elements = Arrays.asList(element, "y", "z");
        StructuredSelection selection = new StructuredSelection(elements);
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).as(String.class), (Matcher)CoreMatchers.is((Object)element));
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).asObject(), (Matcher)CoreMatchers.is((Object)element));
    }

    @Test
    public void adaptableSelectionYieldsElement() {
        final String element = "x";
        IAdaptable adapted = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                return adapter == String.class ? element : null;
            }
        };
        StructuredSelection selection = new StructuredSelection((Object)adapted);
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).as(String.class), (Matcher)CoreMatchers.is((Object)element));
        Assert.assertThat((Object)new ElementFrom((ISelection)selection).asObject(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

