/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.projectusus.bugprison.core.BugList;
import org.projectusus.bugprison.core.internal.BugsWriter;
import org.projectusus.bugprison.core.texts.BugPrisonTexts;
import org.projectusus.core.UsusCorePlugin;

public class SaveBugsJob
extends Job {
    public static final Object FAMILY = new Object();
    private final BugList bugs;
    private final IFile file;

    public SaveBugsJob(IFile file, BugList bugs) {
        super(BugPrisonTexts.SaveBugsJob_title);
        this.file = file;
        this.bugs = bugs;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            String stringContent = this.generateFileContent();
            this.saveToFile(monitor, stringContent);
        }
        catch (CoreException cex) {
            String msg = "Unable to save bugs.";
            UsusCorePlugin.log((String)msg, (Throwable)cex);
        }
        return Status.OK_STATUS;
    }

    private void saveToFile(IProgressMonitor monitor, String stringContent) throws CoreException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringContent.getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)inputStream, true, monitor);
        } else {
            this.file.setContents((InputStream)inputStream, true, true, monitor);
        }
    }

    private String generateFileContent() {
        return new BugsWriter(this.bugs).toXml();
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }
}

