/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core.internal;

import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.core.BugList;
import org.projectusus.bugprison.core.BugMetrics;
import org.projectusus.bugprison.core.internal.BugXmlNames;
import org.projectusus.core.internal.UsusXmlWriter;

public class BugsWriter
extends UsusXmlWriter
implements BugXmlNames {
    private final BugList bugs;

    public BugsWriter(BugList bugs) {
        this.bugs = bugs;
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append(this.openTag("bugs"));
        for (Bug bug : this.bugs) {
            this.toXml(bug, sb);
        }
        sb.append(this.closeTag("bugs"));
        return sb.toString();
    }

    private void toXml(Bug bug, StringBuilder sb) {
        sb.append("  " + this.tagStart("bug"));
        sb.append(this.att("title", bug.getTitle()));
        sb.append(this.att("packageName", bug.getLocation().getPackageName()));
        sb.append(this.att("className", bug.getLocation().getClassName()));
        sb.append(this.att("methodName", bug.getLocation().getMethodName()));
        sb.append(this.att("creationTime", bug.getCreationTime()));
        sb.append(this.att("reportTime", bug.getReportTime()));
        BugMetrics bugMetrics = bug.getBugMetrics();
        sb.append(this.att("cyclomaticComplexity", bugMetrics.getCyclomaticComplexity()));
        sb.append(this.att("methodLength", bugMetrics.getMethodLength()));
        sb.append(this.att("numberOfMethods", bugMetrics.getNumberOfMethods()));
        sb.append(this.tagEndOpen());
        sb.append(this.closeTag("bug"));
    }
}

