/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.core.BugList;
import org.projectusus.bugprison.core.IBuggyProject;
import org.projectusus.bugprison.core.SourceCodeLocation;
import org.projectusus.bugprison.core.internal.LoadBugs;
import org.projectusus.bugprison.core.internal.SaveBugsJob;

class BuggyProject
implements IBuggyProject {
    private static final String BUGS_FILENAME = "usus_bugs.xml";
    private final IProject project;

    BuggyProject(IProject project) {
        this.project = project;
    }

    @Override
    public void saveBug(Bug bug) {
        IFile file = this.project.getFile(BUGS_FILENAME);
        BugList bugs = this.loadFromFile(file);
        bugs.addBug(bug);
        SaveBugsJob saveBugsJob = new SaveBugsJob(file, bugs);
        saveBugsJob.schedule();
    }

    private BugList loadFromFile(IFile file) {
        BugList result = new BugList();
        if (file.exists()) {
            LoadBugs loadBugs = new LoadBugs(file.getLocation().toOSString());
            result.addBugs(loadBugs.load());
        }
        return result;
    }

    @Override
    public BugList getBugs() {
        IFile file = this.project.getFile(BUGS_FILENAME);
        BugList result = this.loadFromFile(file);
        result.setProjectName(this.project.getName());
        return result;
    }

    @Override
    public BugList getBugsFor(IMethod method) {
        BugList bugs = this.getBugs();
        return bugs.filter(SourceCodeLocation.getMethodLocation(method));
    }
}

