/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.joda.time.DateTime;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.core.BugList;
import org.projectusus.bugprison.core.BugMetrics;
import org.projectusus.bugprison.core.MethodLocation;
import org.projectusus.bugprison.core.internal.BugXmlNames;
import org.projectusus.core.internal.UsusXmlReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BugFileReader
extends UsusXmlReader<Bug>
implements BugXmlNames {
    public BugFileReader(Element rootElement) {
        super(rootElement, "bug");
    }

    public void writToFile(IFile file, BugList bugList) {
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(fos);
            o.writeObject(bugList);
            fos.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fos.toByteArray());
            file.create((InputStream)inputStream, false, (IProgressMonitor)new NullProgressMonitor());
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Bug readElement(Node node) {
        Bug result = new Bug();
        this.insertBugMetrics(node, result);
        this.insertLocationInfo(node, result);
        String title = this.loadStringValue(node, "title");
        DateTime reportTime = this.loadDateTime(node, "reportTime");
        DateTime creationTime = this.loadDateTime(node, "creationTime");
        result.setTitle(title);
        result.setReportTime(reportTime);
        result.setCreationTime(creationTime);
        return result;
    }

    private void insertLocationInfo(Node node, Bug result) {
        MethodLocation location = result.getLocation();
        String packageName = this.loadStringValue(node, "packageName");
        String className = this.loadStringValue(node, "className");
        String methodName = this.loadStringValue(node, "methodName");
        location.setPackageName(packageName);
        location.setClassName(className);
        location.setMethodName(methodName);
    }

    private void insertBugMetrics(Node node, Bug bug) {
        BugMetrics bugMetrics = new BugMetrics();
        int cyclomaticComplexity = this.loadInteger(node, "cyclomaticComplexity");
        int methodLength = this.loadInteger(node, "methodLength");
        int numberOfMethods = this.loadInteger(node, "numberOfMethods");
        bugMetrics.setCyclomaticComplexity(cyclomaticComplexity);
        bugMetrics.setMethodLength(methodLength);
        bugMetrics.setNumberOfMethods(numberOfMethods);
        bug.setBugMetrics(bugMetrics);
    }
}

