/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.core.BugList;
import org.projectusus.bugprison.core.MethodLocation;

public class BugListTest {
    private BugList bugs;

    @Before
    public void setUp() {
        this.bugs = new BugList();
    }

    @Test
    public void testFilter() {
        this.addBug();
        BugList filteredBugs = this.bugs.filter(this.createLocation());
        Assert.assertEquals((long)1L, (long)filteredBugs.size());
    }

    @Test
    public void testFilterWithEmptyResult() {
        this.addBug();
        MethodLocation location = this.createLocation();
        location.setClassName("an other classname");
        BugList filteredBugs = this.bugs.filter(location);
        Assert.assertTrue((boolean)filteredBugs.isEmpty());
    }

    private void addBug() {
        Bug bug = new Bug();
        bug.setLocation(this.createLocation());
        this.bugs.addBug(bug);
    }

    private MethodLocation createLocation() {
        MethodLocation result = new MethodLocation();
        result.setProject("project");
        result.setPackageName("packageName");
        result.setClassName("className");
        result.setMethodName("methodName");
        return result;
    }
}

