/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.projectusus.bugprison.core.AverageBugMetrics;
import org.projectusus.bugprison.core.Bug;
import org.projectusus.bugprison.core.MethodLocation;

public class BugList
implements Serializable,
Iterable<Bug> {
    private static final long serialVersionUID = -7139843196318353350L;
    private final List<Bug> bugs = new ArrayList<Bug>();

    public void addBug(Bug bug) {
        this.bugs.add(bug);
    }

    @Override
    public Iterator<Bug> iterator() {
        return this.bugs.iterator();
    }

    public void addBugs(BugList other) {
        this.bugs.addAll(other.bugs);
    }

    public Bug[] getBugs() {
        return this.bugs.toArray(new Bug[this.bugs.size()]);
    }

    public AverageBugMetrics getAverageMetrics() {
        AverageBugMetrics result = new AverageBugMetrics();
        for (Bug bug : this.bugs) {
            result.addBugMetrics(bug.getBugMetrics());
        }
        return result;
    }

    public void addBugs(List<Bug> other) {
        this.bugs.addAll(other);
    }

    public BugList filter(MethodLocation methodLocation) {
        BugList result = new BugList();
        for (Bug bug : this) {
            if (!bug.getLocation().equals(methodLocation)) continue;
            result.addBug(bug);
        }
        return result;
    }

    public int size() {
        return this.bugs.size();
    }

    public boolean isEmpty() {
        return this.bugs.isEmpty();
    }

    public void setProjectName(String projectName) {
        for (Bug bug : this) {
            bug.getLocation().setProject(projectName);
        }
    }
}

