/*
 * Decompiled with CFR 0.152.
 */
package org.projectusus.bugprison.core;

import org.eclipse.core.resources.IProject;
import org.projectusus.bugprison.core.IAverageMetrics;
import org.projectusus.bugprison.core.texts.BugPrisonTexts;
import org.projectusus.core.basis.JavaModelPath;
import org.projectusus.core.statistics.visitors.ClassCountVisitor;
import org.projectusus.core.statistics.visitors.CyclomaticComplexityCountVisitor;
import org.projectusus.core.statistics.visitors.MethodCountVisitor;
import org.projectusus.core.statistics.visitors.MethodLengthCountVisitor;

public class AverageMetrics
implements IAverageMetrics {
    private int numberOfMethods;
    private int totalCC;
    private int totalML;
    private int numberOfClasses;

    @Override
    public double getAverageCyclomaticComplexity() {
        return this.calculateAverage(this.totalCC, this.numberOfMethods);
    }

    private double calculateAverage(int metricValue, int metricValueBasis) {
        if (metricValueBasis == 0) {
            return 0.0;
        }
        return metricValue / metricValueBasis;
    }

    @Override
    public double getAverageMethodLength() {
        return this.calculateAverage(this.totalML, this.numberOfMethods);
    }

    @Override
    public double getAverageNumberOfMethodsInClass() {
        return this.calculateAverage(this.numberOfMethods, this.numberOfClasses);
    }

    public void addProjectResults(IProject project) {
        JavaModelPath path = new JavaModelPath(project);
        this.numberOfMethods += new MethodCountVisitor(path).visitAndReturn().getMethodCount();
        this.numberOfClasses += new ClassCountVisitor(path).visitAndReturn().getClassCount();
        this.totalCC += new CyclomaticComplexityCountVisitor(path).visitAndReturn().getMetricsSum();
        this.totalML += new MethodLengthCountVisitor(path).visitAndReturn().getMetricsSum();
    }

    @Override
    public String getName() {
        return BugPrisonTexts.AverageMetrics_overall;
    }
}

